/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import junit.framework.Assert;
import org.jboss.arquillian.api.Run;
import org.jboss.arquillian.api.RunModeType;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ActivateRunModeTypeClient;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivateRunModeTypeLocalTestCase {
    @Mock
    private ServiceLoader serviceLoader;

    @Test
    public void shouldExportContainerMethodExecutorIfLocalMode() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ActivateRunModeTypeClient handler = new ActivateRunModeTypeClient();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(TestWithRunModeLocal.class));
        Assert.assertNotNull((String)("Should have exported a " + ContainerMethodExecutor.class), (Object)context.get(ContainerMethodExecutor.class));
    }

    @Test
    public void shouldNotExportContainerMethodExecutorIfRemoteMode() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ActivateRunModeTypeClient handler = new ActivateRunModeTypeClient();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(TestWithRunModeRemote.class));
        Assert.assertNull((String)("Should not have exported a " + ContainerMethodExecutor.class), (Object)context.get(ContainerMethodExecutor.class));
    }

    @Test
    public void shouldNotExportContainerMethodExecutorIfNoModeSpecified() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ActivateRunModeTypeClient handler = new ActivateRunModeTypeClient();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(TestWithNoRunMode.class));
        Assert.assertNull((String)("Should not have exported a " + ContainerMethodExecutor.class), (Object)context.get(ContainerMethodExecutor.class));
    }

    private static class TestWithNoRunMode {
        private TestWithNoRunMode() {
        }
    }

    @Run(value=RunModeType.IN_CONTAINER)
    private static class TestWithRunModeRemote {
        private TestWithRunModeRemote() {
        }
    }

    @Run(value=RunModeType.AS_CLIENT)
    private static class TestWithRunModeLocal {
        private TestWithRunModeLocal() {
        }
    }
}

