/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import junit.framework.Assert;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ContainerCreator;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.container.AfterSetup;
import org.jboss.arquillian.spi.event.container.BeforeSetup;
import org.jboss.arquillian.spi.event.container.ContainerEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerCreatorTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer container;
    @Mock
    private EventHandler<ContainerEvent> eventHandler;

    @Test
    public void shouldLoadAndSetupTheContainer() throws Exception {
        Mockito.when((Object)this.serviceLoader.onlyOne(DeployableContainer.class)).thenReturn((Object)this.container);
        Configuration configuration = new Configuration();
        SuiteContext context = new SuiteContext(this.serviceLoader);
        context.add(Configuration.class, (Object)configuration);
        context.register(BeforeSetup.class, this.eventHandler);
        context.register(AfterSetup.class, this.eventHandler);
        ContainerCreator handler = new ContainerCreator();
        handler.callback((Context)context, new SuiteEvent());
        ((DeployableContainer)Mockito.verify((Object)this.container)).setup((Context)context, configuration);
        ((EventHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)2))).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(ContainerEvent.class));
        Assert.assertNotNull((String)("Should have exported " + DeployableContainer.class), (Object)context.get(DeployableContainer.class));
    }
}

