/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.impl.handler.TestEventExecuter;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.event.suite.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestEventExecuterTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private TestMethodExecutor testExecutor;

    @org.junit.Test
    public void shouldReturnPassed() throws Throwable {
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldReturnPassed"));
        TestContext context = new TestContext(new ClassContext(new SuiteContext(this.serviceLoader)));
        Test event = new Test(this.testExecutor);
        TestEventExecuter handler = new TestEventExecuter();
        handler.callback((Context)context, event);
        TestResult result = (TestResult)context.get(TestResult.class);
        Assert.assertNotNull((String)"Should have set result", (Object)result);
        Assert.assertEquals((String)"Should have passed test", (Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((String)"Should not have set cause", (Object)result.getThrowable());
    }

    @org.junit.Test
    public void shouldReturnFailedOnException() throws Throwable {
        Exception exception = new Exception();
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldReturnFailedOnException"));
        ((TestMethodExecutor)Mockito.doThrow((Throwable)exception).when((Object)this.testExecutor)).invoke();
        TestContext context = new TestContext(new ClassContext(new SuiteContext(this.serviceLoader)));
        Test event = new Test(this.testExecutor);
        TestEventExecuter handler = new TestEventExecuter();
        handler.callback((Context)context, event);
        TestResult result = (TestResult)context.get(TestResult.class);
        Assert.assertNotNull((String)"Should have set result", (Object)result);
        Assert.assertEquals((String)"Should have failed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertEquals((String)"Should have set failed cause", (Object)exception, (Object)result.getThrowable());
    }

    private Method getTestMethod(String name) throws Exception {
        return this.getClass().getMethod(name, new Class[0]);
    }
}

