/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.context;

import java.util.Collection;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.ProfileBuilder;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.spi.ClassContextAppender;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.SuiteContextAppender;
import org.jboss.arquillian.spi.TestContextAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoadableProfileBuilder
implements ProfileBuilder {
    private ServiceLoader serviceLoader;
    private ProfileBuilder containerProfileBuilder;

    public ServiceLoadableProfileBuilder(ServiceLoader serviceLoader, ProfileBuilder containerProfilebuilder) {
        Validate.notNull(serviceLoader, "ServiceLoader must be specified");
        Validate.notNull(containerProfilebuilder, "ProfileBuilder must be specified");
        this.serviceLoader = serviceLoader;
        this.containerProfileBuilder = containerProfilebuilder;
    }

    @Override
    public void buildSuiteContext(SuiteContext context) {
        this.containerProfileBuilder.buildSuiteContext(context);
        Collection appenders = this.serviceLoader.all(SuiteContextAppender.class);
        for (SuiteContextAppender appender : appenders) {
            appender.append((Context)context);
        }
    }

    @Override
    public void buildClassContext(ClassContext context, Class<?> testClass) {
        this.containerProfileBuilder.buildClassContext(context, testClass);
        Collection appenders = this.serviceLoader.all(ClassContextAppender.class);
        for (ClassContextAppender appender : appenders) {
            appender.append((Context)context);
        }
    }

    @Override
    public void buildTestContext(TestContext context, Object testInstance) {
        this.containerProfileBuilder.buildTestContext(context, testInstance);
        Collection appenders = this.serviceLoader.all(TestContextAppender.class);
        for (TestContextAppender appender : appenders) {
            appender.append((Context)context);
        }
    }
}

