/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.api.Run;
import org.jboss.arquillian.api.RunModeType;
import org.jboss.arquillian.impl.DeploymentAnnotationArchiveGenerator;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentAnnotationArchiveGeneratorTestCase {
    @Test
    public void shouldGenerateArchiveOnDeploymentNotPresent() throws Exception {
        DeploymentAnnotationArchiveGenerator generator = new DeploymentAnnotationArchiveGenerator();
        TestClass testCase = new TestClass(DeploymentNotPresent.class);
        Archive archive = generator.generateApplicationArchive(testCase);
        Assert.assertNotNull((String)"Archive generated", (Object)archive);
        Assert.assertEquals((Object)DeploymentNotPresent.class.getSimpleName(), (Object)archive.getName());
        ArchivePath path = this.createArchivePath(DeploymentNotPresent.class);
        Assert.assertTrue((String)("Contains " + path), (boolean)archive.contains(path));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentNotStatic() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentNotStatic.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentWrongReturnType() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentWrongReturnType.class));
    }

    @Test
    public void shouldIncludeTestClassInDeployment() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentOK.class));
        ArchivePath testPath = this.createArchivePath(DeploymentOK.class);
        junit.framework.Assert.assertNotNull((Object)archive.contains(testPath));
    }

    @Test
    public void shouldNotIncludeTheTestClassIfClassesNotSupportedByTheArchive() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentClassesNotSupported.class));
        junit.framework.Assert.assertTrue((boolean)archive.getContent().isEmpty());
    }

    @Test
    public void shouldNotIncludeTheTestClassIfRunAsClient() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentRunAsClient.class));
        ArchivePath testPath = this.createArchivePath(DeploymentRunAsClient.class);
        junit.framework.Assert.assertFalse((boolean)archive.contains(testPath));
    }

    private ArchivePath createArchivePath(Class<?> clazz) {
        return ArchivePaths.create((String)(clazz.getName().replaceAll("\\.", "/") + ".class"));
    }

    @Run(value=RunModeType.AS_CLIENT)
    private static class DeploymentRunAsClient {
        private DeploymentRunAsClient() {
        }

        @Deployment
        public static JavaArchive test() {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentClassesNotSupported {
        private DeploymentClassesNotSupported() {
        }

        @Deployment
        public static ResourceAdapterArchive test() {
            return (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class);
        }
    }

    private static class DeploymentOK {
        private DeploymentOK() {
        }

        @Deployment
        public static JavaArchive test() {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentWrongReturnType {
        private DeploymentWrongReturnType() {
        }

        @Deployment
        public Object test() {
            return ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentNotStatic {
        private DeploymentNotStatic() {
        }

        @Deployment
        public Archive<?> test() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentNotPresent {
        private DeploymentNotPresent() {
        }
    }
}

