/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import junit.framework.Assert;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.api.Run;
import org.jboss.arquillian.api.RunModeType;
import org.jboss.arquillian.impl.DeploymentAnnotationArchiveGenerator;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAnnotationArchiveGeneratorTestCase {
    public void shouldGenerateArchiveOnDeploymentNotPresent() throws Exception {
        DeploymentAnnotationArchiveGenerator generator = new DeploymentAnnotationArchiveGenerator();
        TestClass testCase = new TestClass(DeploymentNotPresent.class);
        Archive archive = generator.generateApplicationArchive(testCase);
        Assert.assertNotNull((String)"Archive generated", (Object)archive);
        Assert.assertEquals((String)DeploymentAnnotationArchiveGeneratorTestCase.class.getSimpleName(), (String)archive.getName());
        ArchivePath path = this.createArchivePath(DeploymentAnnotationArchiveGeneratorTestCase.class);
        Assert.assertTrue((String)("Contains " + path), (boolean)archive.contains(path));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentNotStatic() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentNotStatic.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentWrongReturnType() throws Exception {
        new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentWrongReturnType.class));
    }

    @Test
    public void shouldIncludeTestClassInDeployment() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentOK.class));
        ArchivePath testPath = this.createArchivePath(DeploymentOK.class);
        Assert.assertNotNull((Object)archive.contains(testPath));
    }

    @Test
    public void shouldNotIncludeTheTestClassIfClassesNotSupportedByTheArchive() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentClassesNotSupported.class));
        Assert.assertTrue((boolean)archive.getContent().isEmpty());
    }

    @Test
    public void shouldNotIncludeTheTestClassIfRunAsClient() throws Exception {
        Archive archive = new DeploymentAnnotationArchiveGenerator().generateApplicationArchive(new TestClass(DeploymentRunAsClient.class));
        ArchivePath testPath = this.createArchivePath(DeploymentRunAsClient.class);
        Assert.assertFalse((boolean)archive.contains(testPath));
    }

    private ArchivePath createArchivePath(Class<?> clazz) {
        return ArchivePaths.create((String)(clazz.getName().replaceAll("\\.", "/") + ".class"));
    }

    @Run(value=RunModeType.AS_CLIENT)
    private static class DeploymentRunAsClient {
        private DeploymentRunAsClient() {
        }

        @Deployment
        public static JavaArchive test() {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentClassesNotSupported {
        private DeploymentClassesNotSupported() {
        }

        @Deployment
        public static ResourceAdapterArchive test() {
            return (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class);
        }
    }

    private static class DeploymentOK {
        private DeploymentOK() {
        }

        @Deployment
        public static JavaArchive test() {
            return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentWrongReturnType {
        private DeploymentWrongReturnType() {
        }

        @Deployment
        public Object test() {
            return ShrinkWrap.create(JavaArchive.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentNotStatic {
        private DeploymentNotStatic() {
        }

        @Deployment
        public Archive<?> test() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentNotPresent {
        private DeploymentNotPresent() {
        }
    }
}

