/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.context;

import junit.framework.Assert;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.ContextLifecycleManager;
import org.jboss.arquillian.impl.context.ProfileBuilder;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.Event;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.jboss.arquillian.spi.event.suite.TestEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextLifecycleManagerTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ProfileBuilder profileBuilder;
    @Mock
    private EventHandler<SuiteEvent> suiteEventHandler;
    @Mock
    private EventHandler<ClassEvent> classEventHandler;
    @Mock
    private EventHandler<TestEvent> testEventHandler;

    @Test
    public void shouldBeAbleToCreateRestoreSuiteContext() throws Exception {
        ContextLifecycleManager manager = new ContextLifecycleManager(this.profileBuilder, this.serviceLoader);
        SuiteContext context = manager.createRestoreSuiteContext();
        Assert.assertNotNull((String)"Context should have been created", (Object)context);
        SuiteContext context2 = manager.createRestoreSuiteContext();
        Assert.assertNotNull((String)"Context should have been created", (Object)context2);
        Assert.assertTrue((String)"Restore of context should return same instance", (boolean)context.equals(context2));
        manager.destroySuiteContext();
        context2 = manager.createRestoreSuiteContext();
        Assert.assertNotNull((String)"Context should have been created", (Object)context2);
        Assert.assertFalse((String)"Restore of context should return same instance", (boolean)context.equals(context2));
    }

    @Test
    public void shouldBeAbleToCreateRestoreClassContext() throws Exception {
        ContextLifecycleManager manager = new ContextLifecycleManager(this.profileBuilder, this.serviceLoader);
        manager.createRestoreSuiteContext();
        ClassContext context = manager.createRestoreClassContext(this.getClass());
        Assert.assertNotNull((String)"Context should have been created", (Object)context);
        ClassContext context2 = manager.createRestoreClassContext(this.getClass());
        Assert.assertNotNull((String)"Context should have been created", (Object)context2);
        Assert.assertTrue((String)"Restore of context should return same instance", (boolean)context.equals(context2));
        manager.destroyClassContext(this.getClass());
        context2 = manager.createRestoreClassContext(this.getClass());
        Assert.assertNotNull((String)"Context should have been created", (Object)context2);
        Assert.assertFalse((String)"Restore of context should return same instance", (boolean)context.equals(context2));
    }

    @Test
    public void shouldBeAbleToCreateRestoreTestContext() throws Exception {
        ContextLifecycleManager manager = new ContextLifecycleManager(this.profileBuilder, this.serviceLoader);
        manager.createRestoreSuiteContext();
        manager.createRestoreClassContext(this.getClass());
        TestContext context = manager.createRestoreTestContext((Object)this);
        Assert.assertNotNull((String)"Context should have been created", (Object)context);
        TestContext context2 = manager.createRestoreTestContext((Object)this);
        Assert.assertNotNull((String)"Context should have been created", (Object)context2);
        Assert.assertTrue((String)"Restore of context should return same instance", (boolean)context.equals(context2));
        manager.destroyTestContext((Object)this);
        context2 = manager.createRestoreTestContext((Object)this);
        Assert.assertNotNull((String)"Context should have been created", (Object)context2);
        Assert.assertFalse((String)"Restore of context should return same instance", (boolean)context.equals(context2));
    }

    @Test
    public void shouldBeAbleToFireUpwards() throws Exception {
        Before event = new Before(this.getClass(), this.getClass().getMethod("shouldBeAbleToFireUpwards", new Class[0]));
        ContextLifecycleManager manager = new ContextLifecycleManager(this.profileBuilder, this.serviceLoader);
        SuiteContext suiteContext = manager.createRestoreSuiteContext();
        suiteContext.register(Before.class, this.suiteEventHandler);
        ClassContext classContext = manager.createRestoreClassContext(this.getClass());
        classContext.register(Before.class, this.classEventHandler);
        TestContext testContext = manager.createRestoreTestContext((Object)this);
        testContext.register(Before.class, this.testEventHandler);
        testContext.fire((Event)event);
        ((EventHandler)Mockito.verify(this.suiteEventHandler, (VerificationMode)Mockito.times((int)1))).callback((Context)suiteContext, (Object)event);
        ((EventHandler)Mockito.verify(this.classEventHandler, (VerificationMode)Mockito.times((int)1))).callback((Context)classContext, (Object)event);
        ((EventHandler)Mockito.verify(this.testEventHandler, (VerificationMode)Mockito.times((int)1))).callback((Context)testContext, (Object)event);
    }
}

