/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ContainerStopper;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.container.AfterStop;
import org.jboss.arquillian.spi.event.container.BeforeStop;
import org.jboss.arquillian.spi.event.container.ContainerEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerStopperTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer container;
    @Mock
    private EventHandler<ContainerEvent> eventHandler;

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateOnMissingDeployableContainer() throws Exception {
        SuiteContext context = new SuiteContext(this.serviceLoader);
        ContainerStopper handler = new ContainerStopper();
        handler.callback((Context)context, new SuiteEvent());
    }

    @Test
    public void shouldStartTheDeployableContainer() throws Exception {
        SuiteContext context = new SuiteContext(this.serviceLoader);
        context.add(DeployableContainer.class, (Object)this.container);
        context.register(BeforeStop.class, this.eventHandler);
        context.register(AfterStop.class, this.eventHandler);
        ContainerStopper handler = new ContainerStopper();
        handler.callback((Context)context, new SuiteEvent());
        ((DeployableContainer)Mockito.verify((Object)this.container)).stop((Context)context);
        ((EventHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)2))).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(ContainerEvent.class));
    }
}

