/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.context;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.event.EventManager;
import org.jboss.arquillian.impl.event.MapEventManager;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.Event;
import org.jboss.arquillian.spi.event.suite.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventContext
implements Context {
    private EventManager eventManager = new MapEventManager();
    private Map<Class<?>, Object> objectStore = new HashMap();

    public <K extends Event> void register(Class<? extends K> eventType, EventHandler<? super K> handler) {
        this.eventManager.register(eventType, handler);
    }

    protected EventManager getEventManager() {
        return this.eventManager;
    }

    public <B> void add(Class<B> type, B instance) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(instance, "Instance must be specified");
        this.objectStore.put(type, instance);
    }

    public <B> B get(Class<B> type) {
        Context parentContext;
        Validate.notNull(type, "Type must be specified");
        Object instance = this.objectStore.get(type);
        if (instance == null && (parentContext = this.getParentContext()) != null) {
            instance = parentContext.get(type);
        }
        return (B)instance;
    }

    public ServiceLoader getServiceLoader() {
        return this.get(ServiceLoader.class);
    }

    public void fire(Event event) {
        Context parent = this.getParentContext();
        if (parent != null) {
            parent.fire(event);
        }
        this.getEventManager().fire(this, event);
    }
}

