/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import junit.framework.Assert;
import org.jboss.arquillian.api.Run;
import org.jboss.arquillian.api.RunModeType;
import org.jboss.arquillian.impl.ApplicationArchiveDeploymentGenerator;
import org.jboss.arquillian.impl.ClientDeploymentGenerator;
import org.jboss.arquillian.impl.DeploymentGenerator;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ActivateRunModeTypeDeployment;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class ActivateRunModeTypeDeploymentTestCase {
    @Mock
    private ServiceLoader serviceLoader;

    @Test
    public void shouldExportApplicationArchiveDeploymentGeneratorIfLocalMode() throws Exception {
        this.verifyExportAndType(TestWithRunModeLocal.class, ApplicationArchiveDeploymentGenerator.class);
    }

    @Test
    public void shouldExportClientDeploymentGeneratorIfRemoteMode() throws Exception {
        this.verifyExportAndType(TestWithRunModeRemote.class, ClientDeploymentGenerator.class);
    }

    @Test
    public void shouldExportClientDeploymentGeneratorIfNoModeSet() throws Exception {
        this.verifyExportAndType(TestWithRunModeNone.class, ClientDeploymentGenerator.class);
    }

    private void verifyExportAndType(Class<?> testCaseClass, Class<?> deploymentGeneratorClass) throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ActivateRunModeTypeDeployment handler = new ActivateRunModeTypeDeployment();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(testCaseClass));
        Assert.assertNotNull((String)("Should have exported a " + DeploymentGenerator.class), (Object)context.get(DeploymentGenerator.class));
        Assert.assertEquals((String)("Verify that the correct " + DeploymentGenerator.class.getName() + " was exported"), deploymentGeneratorClass, ((DeploymentGenerator)context.get(DeploymentGenerator.class)).getClass());
    }

    private static class TestWithRunModeNone {
        private TestWithRunModeNone() {
        }
    }

    @Run(value=RunModeType.IN_CONTAINER)
    private static class TestWithRunModeRemote {
        private TestWithRunModeRemote() {
        }
    }

    @Run(value=RunModeType.AS_CLIENT)
    private static class TestWithRunModeLocal {
        private TestWithRunModeLocal() {
        }
    }
}

