/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import junit.framework.Assert;
import org.jboss.arquillian.impl.DeploymentGenerator;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ArchiveGenerator;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArchiveGeneratorTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeploymentGenerator generator;
    @Mock
    private DeploymentPackager packager;

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateExceptionOnMissingDeploymentGenerator() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ArchiveGenerator handler = new ArchiveGenerator();
        handler.callback((Context)context, new ClassEvent(new TestClass(this.getClass())));
    }

    @Test
    public void shouldGenerateArchive() throws Exception {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        TestDeployment deployment = new TestDeployment(archive);
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(ServiceLoader.class, (Object)this.serviceLoader);
        context.add(DeploymentGenerator.class, (Object)this.generator);
        TestClass testClass = new TestClass(this.getClass());
        Mockito.when((Object)this.generator.generate(testClass)).thenReturn((Object)deployment);
        Mockito.when((Object)this.serviceLoader.onlyOne(DeploymentPackager.class)).thenReturn((Object)this.packager);
        Mockito.when((Object)this.packager.generateDeployment((Context)context, deployment)).thenReturn((Object)archive);
        ArchiveGenerator handler = new ArchiveGenerator();
        handler.callback((Context)context, new ClassEvent(testClass));
        Assert.assertNotNull((String)("Should have exported " + Archive.class.getSimpleName()), (Object)context.get(Archive.class));
    }
}

