/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.arquillian.spi.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicServiceLoader
implements ServiceLoader {
    private static Logger logger = Logger.getLogger(DynamicServiceLoader.class.getName());

    public <T> Collection<T> all(Class<T> serviceClass) {
        return org.jboss.arquillian.spi.util.ServiceLoader.load(serviceClass).getProviders();
    }

    public <T> T onlyOne(Class<T> serviceClass) {
        Set providers = org.jboss.arquillian.spi.util.ServiceLoader.load(serviceClass).getProviders();
        this.verifyOnlyOneOrSameImplementation(serviceClass, providers);
        return (T)providers.iterator().next();
    }

    private void verifyOnlyOneOrSameImplementation(Class<?> serviceClass, Collection<?> providers) {
        if (providers == null || providers.size() == 0) {
            throw new IllegalStateException("No implementation found for " + serviceClass.getName() + ", please check your classpath");
        }
        if (providers.size() > 1) {
            this.verifySameImplementation(serviceClass, providers);
        }
    }

    private void verifySameImplementation(Class<?> serviceClass, Collection<?> providers) {
        boolean providersAreTheSame = false;
        Class<?> firstProvider = null;
        for (Object provider : providers) {
            if (firstProvider == null) {
                firstProvider = provider.getClass();
                continue;
            }
            if (firstProvider == provider.getClass()) {
                providersAreTheSame = true;
                continue;
            }
            throw new IllegalStateException("More then one implementation found for " + serviceClass.getName() + ", " + "please check your classpath. The found implementations are " + this.toClassString(providers));
        }
        if (providersAreTheSame) {
            logger.warning("More then one reference to the same implementation was found for " + serviceClass.getName() + ", please verify you classpath");
        }
    }

    private String toClassString(Collection<?> providers) {
        StringBuilder sb = new StringBuilder();
        for (Object provider : providers) {
            sb.append(provider.getClass().getName()).append(", ");
        }
        return ((Object)sb.subSequence(0, sb.length() - 2)).toString();
    }
}

