/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import java.io.File;
import java.io.FileOutputStream;
import org.jboss.arquillian.impl.ToolingDeploymentFormatter;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.formatter.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveDeploymentToolingExporter
implements EventHandler<ClassEvent> {
    static final String ARQUILLIAN_TOOLING_DEPLOYMENT_FOLDER = "arquillian.tooling.deployment.folder";

    public void callback(Context context, ClassEvent event) throws Exception {
        String deploymentOutputFolder = System.getProperty(ARQUILLIAN_TOOLING_DEPLOYMENT_FOLDER);
        if (deploymentOutputFolder == null) {
            return;
        }
        Archive deployment = (Archive)context.get(Archive.class);
        if (deployment == null) {
            return;
        }
        TestClass testClass = event.getTestClass();
        String deploymentContent = deployment.toString((Formatter)new ToolingDeploymentFormatter(testClass.getJavaClass()));
        this.writeOutToFile(new File(deploymentOutputFolder + "/" + testClass.getName() + ".xml"), deploymentContent);
    }

    protected void writeOutToFile(File target, String content) {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(content, "Content must be specified");
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(target);
            output.write(content.getBytes());
            output.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write content to file", e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close output stream", e);
                }
            }
        }
    }
}

