/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.Collection;
import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.junit.Assert;
import org.junit.Test;

public class DynamicServiceLoaderTestCase {
    @Test(expected=IllegalStateException.class)
    public void shouldFailIfMultipleProvidersFound() throws Exception {
        new DynamicServiceLoader().onlyOne(Service.class);
    }

    @Test
    public void shouldNotFailIfMultipleProvidersFoundPointingToSameImpl() throws Exception {
        Service2 service = (Service2)new DynamicServiceLoader().onlyOne(Service2.class);
        Assert.assertTrue((String)"verify that a instance of Service2Impl was loaded", (service.getClass() == Service2Impl.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldLoadAllInstances() throws Exception {
        Collection services = new DynamicServiceLoader().all(Service.class);
        Assert.assertEquals((String)"verify that all services where found and loaded", (long)2L, (long)services.size());
    }

    @Test
    public void shouldReturnDefinedOrderInServicesFile() throws Exception {
        for (int i = 0; i < 10; ++i) {
            Collection services = new DynamicServiceLoader().all(Service.class);
            this.verifyOrder(services);
        }
    }

    @Test
    public void shouldReturnDefaultServiceImplIfNoOtherIsFound() throws Exception {
        NonRegisteredService service = (NonRegisteredService)new DynamicServiceLoader().onlyOne(NonRegisteredService.class, DefaultNonRegisteredServiceImpl.class);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((String)"Verify that the default provided service class was returned", DefaultNonRegisteredServiceImpl.class, service.getClass());
    }

    @Test
    public void shouldNotReturnDefaultServiceImplIfOtherIsFound() throws Exception {
        Service2 service = (Service2)new DynamicServiceLoader().onlyOne(Service2.class, DefaultService2Impl.class);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((String)"Verify that the default provided service class was returned", Service2Impl.class, service.getClass());
    }

    private void verifyOrder(Collection<Service> services) {
        int i = 0;
        for (Service service : services) {
            switch (i) {
                case 0: {
                    Assert.assertEquals(service.getClass(), ServiceImpl1.class);
                    break;
                }
                case 1: {
                    Assert.assertEquals(service.getClass(), ServiceImpl2.class);
                }
            }
            ++i;
        }
    }

    public static class DefaultNonRegisteredServiceImpl
    implements NonRegisteredService {
    }

    public static interface NonRegisteredService {
    }

    public static class DefaultService2Impl
    implements Service2 {
    }

    public static class Service2Impl
    implements Service2 {
    }

    public static interface Service2 {
    }

    public static class ServiceImpl2
    implements Service {
    }

    public static class ServiceImpl1
    implements Service {
    }

    public static interface Service {
    }
}

