/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.event;

import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.event.FiredEventException;
import org.jboss.arquillian.impl.event.MapEventManager;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.Event;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EventManagerTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private EventHandler<SuiteEvent> handler;

    @Test(expected=FiredEventException.class)
    public void shouldWrapException() throws Exception {
        ((EventHandler)Mockito.doThrow((Throwable)new Exception()).when(this.handler)).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(SuiteEvent.class));
        SuiteContext context = new SuiteContext(this.serviceLoader);
        SuiteEvent event = new SuiteEvent();
        MapEventManager manager = new MapEventManager();
        manager.register(SuiteEvent.class, this.handler);
        manager.fire((Context)context, (Event)event);
    }

    @Test
    public void shouldBeAbleToRegisterAndFireToMultipleHandlersOnSameEvent() throws Exception {
        int handlerCount = 2;
        SuiteContext context = new SuiteContext(this.serviceLoader);
        SuiteEvent event = new SuiteEvent();
        MapEventManager manager = new MapEventManager();
        for (int i = 0; i < handlerCount; ++i) {
            manager.register(SuiteEvent.class, this.handler);
        }
        manager.fire((Context)context, (Event)event);
        ((EventHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)handlerCount))).callback((Context)context, (Object)event);
    }
}

