/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.impl.DeploymentAnnotationArchiveGenerator;
import org.jboss.arquillian.impl.DeploymentGenerator;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.ApplicationArchiveGenerator;
import org.jboss.arquillian.spi.ApplicationArchiveProcessor;
import org.jboss.arquillian.spi.AuxiliaryArchiveAppender;
import org.jboss.arquillian.spi.AuxiliaryArchiveProcessor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.shrinkwrap.api.Archive;

public class ClientDeploymentGenerator
implements DeploymentGenerator {
    private ServiceLoader serviceLoader;

    public ClientDeploymentGenerator(ServiceLoader serviceLoader) {
        Validate.notNull(serviceLoader, "ServiceLoader must be specified");
        this.serviceLoader = serviceLoader;
    }

    @Override
    public Archive<?> generate(Context context, TestClass testCase) {
        Validate.notNull(testCase, "TestCase must be specified");
        DeploymentPackager packager = (DeploymentPackager)this.serviceLoader.onlyOne(DeploymentPackager.class);
        Archive applicationArchive = ((ApplicationArchiveGenerator)this.serviceLoader.onlyOne(ApplicationArchiveGenerator.class, DeploymentAnnotationArchiveGenerator.class)).generateApplicationArchive(testCase);
        this.applyApplicationProcessors(applicationArchive, testCase);
        List<Archive<?>> auxiliaryArchives = this.loadAuxiliaryArchives();
        this.applyAuxiliaryProcessors(auxiliaryArchives);
        TestDeployment deployment = new TestDeployment(applicationArchive, auxiliaryArchives);
        context.add(TestDeployment.class, (Object)deployment);
        return packager.generateDeployment(context, deployment);
    }

    private List<Archive<?>> loadAuxiliaryArchives() {
        ArrayList archives = new ArrayList();
        Collection archiveAppenders = this.serviceLoader.all(AuxiliaryArchiveAppender.class);
        for (AuxiliaryArchiveAppender archiveAppender : archiveAppenders) {
            archives.add(archiveAppender.createAuxiliaryArchive());
        }
        return archives;
    }

    private void applyApplicationProcessors(Archive<?> applicationArchive, TestClass testClass) {
        Collection processors = this.serviceLoader.all(ApplicationArchiveProcessor.class);
        for (ApplicationArchiveProcessor processor : processors) {
            processor.process(applicationArchive, testClass);
        }
    }

    private void applyAuxiliaryProcessors(List<Archive<?>> auxiliaryArchives) {
        Collection processors = this.serviceLoader.all(AuxiliaryArchiveProcessor.class);
        for (AuxiliaryArchiveProcessor processor : processors) {
            for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
                processor.process(auxiliaryArchive);
            }
        }
    }
}

