/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.Logger;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.util.SecurityActions;
import org.jboss.arquillian.spi.util.TCCLActions;

public class DynamicServiceLoader
implements ServiceLoader {
    private static Logger logger = Logger.getLogger((String)DynamicServiceLoader.class.getName());
    private static final String SERVICES = "META-INF/services";

    public <T> Collection<T> all(Class<T> serviceClass) {
        Validate.notNull(serviceClass, "ServiceClass must be provided");
        return this.createInstances(serviceClass, this.load(serviceClass, TCCLActions.getClassLoader()));
    }

    public <T> T onlyOne(Class<T> serviceClass) {
        Validate.notNull(serviceClass, "ServiceClass must be provided");
        Set<Class<T>> serviceImpls = this.load(serviceClass, TCCLActions.getClassLoader());
        this.verifyOnlyOneOrSameImplementation(serviceClass, serviceImpls);
        return this.createInstance(serviceImpls.iterator().next());
    }

    public <T> T onlyOne(Class<T> serviceClass, Class<? extends T> defaultServiceClass) {
        Validate.notNull(serviceClass, "ServiceClass must be provided");
        Validate.notNull(defaultServiceClass, "DefaultServiceClass must be provided");
        Class<? extends T> serviceImplToCreate = defaultServiceClass;
        Set<Class<T>> serviceImpls = this.load(serviceClass, TCCLActions.getClassLoader());
        if (serviceImpls.size() > 0) {
            this.verifySameImplementation(serviceClass, serviceImpls);
            serviceImplToCreate = serviceImpls.iterator().next();
        }
        return this.createInstance(serviceImplToCreate);
    }

    private <T> void verifyOnlyOneOrSameImplementation(Class<T> serviceClass, Collection<Class<? extends T>> providers) {
        if (providers == null || providers.size() == 0) {
            throw new IllegalStateException("No implementation found for " + serviceClass.getName() + ", please check your classpath");
        }
        if (providers.size() > 1) {
            this.verifySameImplementation(serviceClass, providers);
        }
    }

    private <T> void verifySameImplementation(Class<T> serviceClass, Collection<Class<? extends T>> providers) {
        boolean providersAreTheSame = false;
        Class<T> firstProvider = null;
        for (Class<T> clazz : providers) {
            if (firstProvider == null) {
                firstProvider = clazz;
                continue;
            }
            if (firstProvider == clazz) {
                providersAreTheSame = true;
                continue;
            }
            throw new IllegalStateException("More then one implementation found for " + serviceClass.getName() + ", " + "please check your classpath. The found implementations are " + this.toClassString(providers));
        }
        if (providersAreTheSame) {
            logger.warning("More then one reference to the same implementation was found for " + serviceClass.getName() + ", please verify you classpath");
        }
    }

    private String toClassString(Collection<?> providers) {
        StringBuilder sb = new StringBuilder();
        for (Object provider : providers) {
            sb.append(provider.getClass().getName()).append(", ");
        }
        return ((Object)sb.subSequence(0, sb.length() - 2)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<Class<? extends T>> load(Class<T> serviceClass, ClassLoader loader) {
        String serviceFile = "META-INF/services/" + serviceClass.getName();
        LinkedHashSet<Class<T>> providers = new LinkedHashSet<Class<T>>();
        try {
            Enumeration<URL> enumeration = loader.getResources(serviceFile);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream is = url.openStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        int comment = line.indexOf(35);
                        if (comment > -1) {
                            line = line.substring(0, comment);
                        }
                        line.trim();
                        if (line.length() > 0) {
                            try {
                                providers.add(loader.loadClass(line).asSubclass(serviceClass));
                            }
                            catch (ClassCastException e) {
                                throw new IllegalStateException("Service " + line + " does not implement expected type " + serviceClass.getName());
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load services for " + serviceClass.getName(), e);
        }
        return providers;
    }

    private <T> T createInstance(Class<? extends T> serviceImplClass) {
        try {
            Constructor constructor = SecurityActions.getConstructor(serviceImplClass, (Class[])new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of Service implementation " + serviceImplClass.getName(), e);
        }
    }

    private <T> Set<T> createInstances(Class<T> serviceType, Set<Class<? extends T>> providers) {
        LinkedHashSet<T> providerImpls = new LinkedHashSet<T>();
        for (Class<T> clazz : providers) {
            providerImpls.add(this.createInstance(clazz));
        }
        return providerImpls;
    }
}

