/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import org.jboss.arquillian.impl.handler.ContainerStarter;
import org.jboss.arquillian.impl.handler.ContainerStopper;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;

public class ContainerRestarter
implements EventHandler<SuiteEvent> {
    private int deploymentCount = 0;

    public void callback(Context context, SuiteEvent event) throws Exception {
        if (this.shouldRestart(context)) {
            new ContainerStopper().callback(context, event);
            new ContainerStarter().callback(context, event);
        }
    }

    private boolean shouldRestart(Context context) {
        int maxDeployments;
        Configuration configuration = (Configuration)context.get(Configuration.class);
        int n = maxDeployments = configuration == null ? -1 : configuration.getMaxDeploymentsBeforeRestart();
        if (maxDeployments > -1 && maxDeployments - 1 == this.deploymentCount) {
            this.deploymentCount = 0;
            return true;
        }
        ++this.deploymentCount;
        return false;
    }
}

