/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.impl.handler.ContainerTestExecuter;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.event.suite.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerTestExecuterTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ContainerMethodExecutor executor;
    @Mock
    private TestMethodExecutor testExecutor;

    @org.junit.Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateOnMissingContainerMethodExecutor() throws Exception {
        TestContext context = new TestContext(new ClassContext(new SuiteContext(this.serviceLoader)));
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldThrowIllegalStateOnMissingContainerMethodExecutor"));
        ContainerTestExecuter handler = new ContainerTestExecuter();
        handler.callback((Context)context, new Test(this.testExecutor));
    }

    @org.junit.Test
    public void shouldInvokeContainerMethodExecutor() throws Exception {
        TestResult result = new TestResult(TestResult.Status.PASSED);
        Mockito.when((Object)this.executor.invoke(this.testExecutor)).thenReturn((Object)result);
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldInvokeContainerMethodExecutor"));
        TestContext context = new TestContext(new ClassContext(new SuiteContext(this.serviceLoader)));
        context.add(ContainerMethodExecutor.class, (Object)this.executor);
        ContainerTestExecuter handler = new ContainerTestExecuter();
        handler.callback((Context)context, new Test(this.testExecutor));
    }

    @org.junit.Test
    public void shouldSetTestResult() throws Exception {
        TestResult result = new TestResult(TestResult.Status.PASSED);
        Mockito.when((Object)this.executor.invoke(this.testExecutor)).thenReturn((Object)result);
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldSetTestResult"));
        TestContext context = new TestContext(new ClassContext(new SuiteContext(this.serviceLoader)));
        context.add(ContainerMethodExecutor.class, (Object)this.executor);
        Test event = new Test(this.testExecutor);
        ContainerTestExecuter handler = new ContainerTestExecuter();
        handler.callback((Context)context, event);
        Assert.assertEquals((String)"Should set result on event", (Object)result, (Object)context.get(TestResult.class));
    }

    private Method getTestMethod(String name) throws Exception {
        return this.getClass().getMethod(name, new Class[0]);
    }
}

