/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import java.io.File;
import junit.framework.Assert;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ArchiveDeploymentExporter;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArchiveDeploymentExporterTestCase {
    private static final String ARCHIVE_NAME = "test.jar";
    private static final String EXPORT_PATH = "target/";
    @Mock
    private ServiceLoader serviceLoader;

    @Test
    public void shouldHandleNoArchiveInContext() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ArchiveDeploymentExporter handler = new ArchiveDeploymentExporter();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(this.getClass()));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldHandleNoConfigurationInContext() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(Archive.class, (Object)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ARCHIVE_NAME)).addClass(this.getClass()));
        ArchiveDeploymentExporter handler = new ArchiveDeploymentExporter();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(this.getClass()));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldNotExportIfDeploymentExportPathNotSet() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(Archive.class, (Object)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ARCHIVE_NAME)).addClass(this.getClass()));
        context.add(Configuration.class, (Object)new Configuration());
        ArchiveDeploymentExporter handler = new ArchiveDeploymentExporter();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(this.getClass()));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldBeExportedWhenDeploymentExportPathIsSet() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setDeploymentExportPath(EXPORT_PATH);
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(Archive.class, (Object)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ARCHIVE_NAME)).addClass(this.getClass()));
        context.add(Configuration.class, (Object)configuration);
        ArchiveDeploymentExporter handler = new ArchiveDeploymentExporter();
        handler.callback((Context)context, (ClassEvent)new BeforeClass(this.getClass()));
        this.fileShouldExist(true);
    }

    private void fileShouldExist(boolean bol) {
        File file = new File(EXPORT_PATH + this.getClass().getName() + "_" + ARCHIVE_NAME);
        Assert.assertEquals((String)"File exists", (boolean)bol, (boolean)file.exists());
        file.delete();
    }
}

