/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ContainerRestarter;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.event.container.AfterStart;
import org.jboss.arquillian.spi.event.container.AfterStop;
import org.jboss.arquillian.spi.event.container.BeforeStart;
import org.jboss.arquillian.spi.event.container.BeforeStop;
import org.jboss.arquillian.spi.event.container.ContainerEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerRestarterTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer container;
    @Mock
    private EventHandler<ContainerEvent> eventHandler;

    @Test
    public void shouldRestartContainerForEveryX() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setMaxDeploymentsBeforeRestart(5);
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(Configuration.class, (Object)configuration);
        context.add(DeployableContainer.class, (Object)this.container);
        context.register(BeforeStart.class, this.eventHandler);
        context.register(AfterStart.class, this.eventHandler);
        context.register(BeforeStop.class, this.eventHandler);
        context.register(AfterStop.class, this.eventHandler);
        ContainerRestarter handler = new ContainerRestarter();
        for (int i = 0; i < 10; ++i) {
            handler.callback((Context)context, new SuiteEvent());
        }
        ((DeployableContainer)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)2))).stop((Context)context);
        ((DeployableContainer)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)2))).start((Context)context);
        ((EventHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)8))).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(ContainerEvent.class));
    }

    @Test
    public void shouldNotForceRestartIfMaxDeploymentsNotSet() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setMaxDeploymentsBeforeRestart(-1);
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        context.add(Configuration.class, (Object)configuration);
        context.add(DeployableContainer.class, (Object)this.container);
        context.register(BeforeStart.class, this.eventHandler);
        context.register(AfterStart.class, this.eventHandler);
        context.register(BeforeStop.class, this.eventHandler);
        context.register(AfterStop.class, this.eventHandler);
        ContainerRestarter handler = new ContainerRestarter();
        for (int i = 0; i < 10; ++i) {
            handler.callback((Context)context, new SuiteEvent());
        }
        ((DeployableContainer)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)0))).stop((Context)context);
        ((DeployableContainer)Mockito.verify((Object)this.container, (VerificationMode)Mockito.times((int)0))).start((Context)context);
        ((EventHandler)Mockito.verify(this.eventHandler, (VerificationMode)Mockito.times((int)0))).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(ContainerEvent.class));
    }
}

