/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.api.Run;
import org.jboss.arquillian.api.RunModeType;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.ApplicationArchiveGenerator;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class DeploymentAnnotationArchiveGenerator
implements ApplicationArchiveGenerator {
    public Archive<?> generateApplicationArchive(TestClass testCase) {
        Archive archive;
        Validate.notNull(testCase, "TestCase must be specified");
        Method deploymentMethod = testCase.getMethod(Deployment.class);
        if (deploymentMethod != null) {
            if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
                throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " is not static");
            }
            if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
                throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " must have return type " + Archive.class.getName());
            }
            try {
                archive = (Archive)deploymentMethod.invoke(null, new Object[0]);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get Deployment", e);
            }
        } else {
            archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)testCase.getSimpleName());
        }
        try {
            RunModeType runMode = RunModeType.IN_CONTAINER;
            if (testCase.isAnnotationPresent(Run.class)) {
                runMode = ((Run)testCase.getAnnotation(Run.class)).value();
            }
            try {
                if (ClassContainer.class.isInstance(archive) && runMode == RunModeType.IN_CONTAINER) {
                    ClassContainer classContainer = (ClassContainer)ClassContainer.class.cast(archive);
                    classContainer.addClass(testCase.getJavaClass());
                }
            }
            catch (UnsupportedOperationException e) {}
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get Deployment", e);
        }
        return archive;
    }
}

