/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.event.EventManager;
import org.jboss.arquillian.impl.event.FiredEventException;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.event.Event;
import org.jboss.arquillian.spi.event.suite.EventHandler;

public class MapEventManager
implements EventManager {
    private Map<Class<? extends Event>, List<EventHandler>> handlerRegistry = new ConcurrentHashMap<Class<? extends Event>, List<EventHandler>>();

    @Override
    public void fire(Context context, Event event) {
        Validate.notNull(context, "Context must be specified");
        Validate.notNull(event, "Event must be specified");
        List<EventHandler> handlers = this.handlerRegistry.get(event.getClass());
        if (handlers != null) {
            try {
                for (int i = 0; i < handlers.size(); ++i) {
                    EventHandler handler = handlers.get(i);
                    handler.callback(context, (Object)event);
                }
            }
            catch (Exception e) {
                throw new FiredEventException(context, event, e);
            }
        }
    }

    @Override
    public <K extends Event> void register(Class<? extends K> eventType, EventHandler<? super K> handler) {
        Validate.notNull(eventType, "EventType must be specified");
        Validate.notNull(handler, "EventHandler must be specified");
        List<EventHandler> handlers = this.handlerRegistry.get(eventType);
        if (handlers == null) {
            handlers = new ArrayList<EventHandler>();
        }
        handlers.add(handler);
        this.handlerRegistry.put(eventType, handlers);
    }
}

