/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.jboss.arquillian.impl.EventTestRunnerAdaptor;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.ContextLifecycleManager;
import org.jboss.arquillian.impl.context.ProfileBuilder;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.context.TestContext;
import org.jboss.arquillian.impl.event.FiredEventException;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.AfterClass;
import org.jboss.arquillian.spi.event.suite.AfterSuite;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.arquillian.spi.event.suite.SuiteEvent;
import org.jboss.arquillian.spi.event.suite.Test;
import org.jboss.arquillian.spi.event.suite.TestEvent;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EventTestRunnerAdaptorTestCase {
    @Mock
    public ServiceLoader serviceLoader;
    @Mock
    public ProfileBuilder profileBuilder;
    @Mock
    private EventHandler<SuiteEvent> suiteEventHandler;
    @Mock
    private EventHandler<ClassEvent> classEventHandler;
    @Mock
    private EventHandler<TestEvent> testEventHandler;

    @org.junit.Before
    public void createContexts() throws Exception {
        ((ProfileBuilder)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                SuiteContext context = (SuiteContext)invocation.getArguments()[0];
                context.register(BeforeSuite.class, EventTestRunnerAdaptorTestCase.this.suiteEventHandler);
                context.register(AfterSuite.class, EventTestRunnerAdaptorTestCase.this.suiteEventHandler);
                return null;
            }
        }).when((Object)this.profileBuilder)).buildSuiteContext((SuiteContext)Mockito.any(SuiteContext.class));
        ((ProfileBuilder)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ClassContext context = (ClassContext)invocation.getArguments()[0];
                context.register(BeforeClass.class, EventTestRunnerAdaptorTestCase.this.classEventHandler);
                context.register(AfterClass.class, EventTestRunnerAdaptorTestCase.this.classEventHandler);
                return null;
            }
        }).when((Object)this.profileBuilder)).buildClassContext((ClassContext)Mockito.any(ClassContext.class), (Class)Mockito.any(Class.class));
        ((ProfileBuilder)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                TestContext context = (TestContext)invocation.getArguments()[0];
                context.register(Before.class, EventTestRunnerAdaptorTestCase.this.testEventHandler);
                context.register(Test.class, EventTestRunnerAdaptorTestCase.this.testEventHandler);
                context.register(After.class, EventTestRunnerAdaptorTestCase.this.testEventHandler);
                return null;
            }
        }).when((Object)this.profileBuilder)).buildTestContext((TestContext)Mockito.any(TestContext.class), Mockito.any(Class.class));
    }

    @org.junit.Test
    public void shouldHandleLifeCycleEvents() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor(new ContextLifecycleManager(this.profileBuilder, this.serviceLoader));
        Class<?> testClass = this.getClass();
        Method testMethod = testClass.getMethod("shouldHandleLifeCycleEvents", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getInstance()).thenReturn((Object)testInstance);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        adaptor.beforeSuite();
        adaptor.beforeClass(testClass);
        adaptor.before((Object)testInstance, testMethod);
        adaptor.test(testExecutor);
        adaptor.after((Object)testInstance, testMethod);
        adaptor.afterClass(testClass);
        adaptor.afterSuite();
        ((EventHandler)Mockito.verify(this.suiteEventHandler, (VerificationMode)Mockito.times((int)2))).callback((Context)Mockito.any(SuiteContext.class), Mockito.any(SuiteEvent.class));
        ((EventHandler)Mockito.verify(this.classEventHandler, (VerificationMode)Mockito.times((int)2))).callback((Context)Mockito.any(ClassContext.class), Mockito.any(ClassEvent.class));
        ((EventHandler)Mockito.verify(this.testEventHandler, (VerificationMode)Mockito.times((int)3))).callback((Context)Mockito.any(TestContext.class), Mockito.any(TestEvent.class));
    }

    @org.junit.Test
    public void shouldHandleAfterCallIfBeforeSuiteFails() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor(new ContextLifecycleManager(this.profileBuilder, this.serviceLoader));
        Class<?> testClass = this.getClass();
        Method testMethod = testClass.getMethod("shouldHandleLifeCycleEvents", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getInstance()).thenReturn((Object)testInstance);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        ((EventHandler)Mockito.doThrow((Throwable)new DeploymentException("TEST")).when(this.suiteEventHandler)).callback((Context)Mockito.any(Context.class), Mockito.isA(BeforeSuite.class));
        Assert.assertNull((String)"verify no active context before", (Object)adaptor.getActiveContext());
        try {
            adaptor.beforeSuite();
            Assert.fail((String)"BeforeSuite should have thrown exeption");
        }
        catch (FiredEventException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"verify SuiteContext has been pushed to stack, even with exception", SuiteContext.class, adaptor.getActiveContext().getClass());
        adaptor.afterSuite();
        Assert.assertNull((String)"Verify SuiteContext has been popped from stack, we're not outside any Context", (Object)adaptor.getActiveContext());
    }

    @org.junit.Test
    public void shouldHandleAfterCallIfBeforeClassFails() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor(new ContextLifecycleManager(this.profileBuilder, this.serviceLoader));
        Class<?> testClass = this.getClass();
        Method testMethod = testClass.getMethod("shouldHandleLifeCycleEvents", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getInstance()).thenReturn((Object)testInstance);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        ((EventHandler)Mockito.doThrow((Throwable)new DeploymentException("TEST")).when(this.classEventHandler)).callback((Context)Mockito.any(Context.class), Mockito.isA(BeforeClass.class));
        Assert.assertNull((String)"verify no active context before", (Object)adaptor.getActiveContext());
        adaptor.beforeSuite();
        Assert.assertEquals((String)"verify SuiteContext has been pushed to stack", SuiteContext.class, adaptor.getActiveContext().getClass());
        try {
            adaptor.beforeClass(testClass);
            Assert.fail((String)"BeforeClass should have thrown exeption");
        }
        catch (FiredEventException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"verify ClassContext has been pushed to stack, even with exception", ClassContext.class, adaptor.getActiveContext().getClass());
        adaptor.afterClass(testClass);
        Assert.assertEquals((String)"verify ClassContext has been popped from stack, we're now at SuiteContext", SuiteContext.class, adaptor.getActiveContext().getClass());
        adaptor.afterSuite();
        Assert.assertNull((String)"Verify SuiteContext has been popped from stack, we're not outside any Context", (Object)adaptor.getActiveContext());
    }

    @org.junit.Test
    public void shouldHandleAfterCallIfBeforeFails() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor(new ContextLifecycleManager(this.profileBuilder, this.serviceLoader));
        Class<?> testClass = this.getClass();
        Method testMethod = testClass.getMethod("shouldHandleLifeCycleEvents", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getInstance()).thenReturn((Object)testInstance);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        ((EventHandler)Mockito.doThrow((Throwable)new DeploymentException("TEST")).when(this.testEventHandler)).callback((Context)Mockito.any(Context.class), Mockito.isA(Before.class));
        Assert.assertNull((String)"verify no active context before", (Object)adaptor.getActiveContext());
        adaptor.beforeSuite();
        Assert.assertEquals((String)"verify SuiteContext has been pushed to stack", SuiteContext.class, adaptor.getActiveContext().getClass());
        adaptor.beforeClass(testClass);
        Assert.assertEquals((String)"verify ClassContext has been pushed to stack", ClassContext.class, adaptor.getActiveContext().getClass());
        try {
            adaptor.before((Object)testInstance, testMethod);
            Assert.fail((String)"Before should have thrown exeption");
        }
        catch (FiredEventException e) {
            // empty catch block
        }
        Assert.assertEquals((String)"verify ClassContext has been pushed to stack, even with exception", TestContext.class, adaptor.getActiveContext().getClass());
        adaptor.after((Object)testInstance, testMethod);
        Assert.assertEquals((String)"verify TestContext has been popped from stack, we're now at ClassContext", ClassContext.class, adaptor.getActiveContext().getClass());
        adaptor.afterClass(testClass);
        Assert.assertEquals((String)"verify ClassContext has been popped from stack, we're now at SuiteContext", SuiteContext.class, adaptor.getActiveContext().getClass());
        adaptor.afterSuite();
        Assert.assertNull((String)"Verify SuiteContext has been popped from stack, we're not outside any Context", (Object)adaptor.getActiveContext());
    }
}

