/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.impl.XmlConfigurationBuilder;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ConfigurationException;
import org.jboss.arquillian.spi.ContainerConfiguration;
import org.jboss.arquillian.spi.ContainerProfile;
import org.jboss.arquillian.spi.ExtensionConfiguration;
import org.jboss.arquillian.spi.ServiceLoader;
import org.junit.Assert;
import org.junit.Test;

public class XmlConfigurationBuilderTestCase {
    @Test
    public void testNonExistingConfigurationFile() throws Exception {
        XmlConfigurationBuilder builder = new XmlConfigurationBuilder("non-existing.xml");
        Configuration configuration = builder.build();
        Assert.assertNotNull((Object)configuration);
        Assert.assertNull((Object)configuration.getContainerConfig(MockContainerConfiguration.class));
    }

    @Test
    public void testValidConfigurationFile() throws Exception {
        MockServiceLoader serviceLoader = new MockServiceLoader(new MockContainerConfiguration());
        XmlConfigurationBuilder builder = new XmlConfigurationBuilder("arquillian.xml", (ServiceLoader)serviceLoader);
        Configuration configuration = builder.build();
        Assert.assertNotNull((Object)configuration);
        Assert.assertEquals((String)("Should set properties on " + Configuration.class.getName()), (Object)"/tmp/", (Object)configuration.getDeploymentExportPath());
        MockContainerConfiguration containerConfig = (MockContainerConfiguration)configuration.getContainerConfig(MockContainerConfiguration.class);
        Assert.assertNotNull((Object)containerConfig);
        Assert.assertEquals((Object)"hola", (Object)containerConfig.getPropertyString());
        Assert.assertEquals((long)1L, (long)containerConfig.getPropertyInt());
        Assert.assertEquals((long)2L, (long)containerConfig.getPropertyLong());
        Assert.assertEquals((double)3.0, (double)containerConfig.getPropertyDouble(), (double)0.0);
        Assert.assertEquals((Object)true, (Object)containerConfig.getPropertyBoolean());
        Assert.assertEquals((Object)"inherited", (Object)containerConfig.getPropertyInherited());
        Assert.assertEquals((Object)"char", (Object)containerConfig.getC());
    }

    @Test(expected=ConfigurationException.class)
    public void testInvalidConfigurationFile() throws Exception {
        new XmlConfigurationBuilder("broken_arquillian.xml").build();
    }

    @Test
    public void testLoadDefaultConfigurationOnMissingFile() throws Exception {
        Configuration configuration = new XmlConfigurationBuilder("missing_arquillian.xml", (ServiceLoader)new MockServiceLoader(new MockContainerConfiguration())).build();
        ContainerConfiguration containerConfiguration = configuration.getActiveContainerConfiguration();
        Assert.assertNotNull((Object)containerConfiguration);
        MockContainerConfiguration mockContainerConfiguration = (MockContainerConfiguration)configuration.getContainerConfig(MockContainerConfiguration.class);
        Assert.assertNotNull((Object)mockContainerConfiguration);
    }

    @Test
    public void testMockExtensionConfiguration() throws Exception {
        MockServiceLoader serviceLoader = new MockServiceLoader(new MockExtensionConfiguration());
        XmlConfigurationBuilder builder = new XmlConfigurationBuilder("arquillian-extension.xml", (ServiceLoader)serviceLoader);
        Configuration configuration = builder.build();
        Assert.assertNotNull((Object)configuration);
        MockExtensionConfiguration extensionConfig = (MockExtensionConfiguration)configuration.getExtensionConfig(MockExtensionConfiguration.class);
        Assert.assertNotNull((Object)extensionConfig);
        Assert.assertEquals((Object)"*superbrowser /usr/local/bin/superbrowser", (Object)extensionConfig.getBrowser());
        Assert.assertEquals((long)8888L, (long)extensionConfig.getServerPort());
        Assert.assertEquals((Object)"localhost", (Object)extensionConfig.getServerHost());
    }

    class MockExtensionConfiguration
    implements ExtensionConfiguration {
        private String browser;
        private int serverPort;
        private String serverHost;

        MockExtensionConfiguration() {
        }

        public String getBrowser() {
            return this.browser;
        }

        public void setBrowser(String browser) {
            this.browser = browser;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        public String getServerHost() {
            return this.serverHost;
        }

        public void setServerHost(String serverHost) {
            this.serverHost = serverHost;
        }
    }

    class MockContainerConfiguration
    extends AbstractMockContainerConfiguration
    implements ContainerConfiguration {
        private String propertyString;
        private int propertyInt;
        private long propertyLong;
        private double propertyDouble;
        private boolean propertyBoolean;
        private String c;

        MockContainerConfiguration() {
        }

        public ContainerProfile getContainerProfile() {
            return ContainerProfile.STANDALONE;
        }

        public String getPropertyString() {
            return this.propertyString;
        }

        public void setPropertyString(String propertyString) {
            this.propertyString = propertyString;
        }

        public int getPropertyInt() {
            return this.propertyInt;
        }

        public void setPropertyInt(int propertyInt) {
            this.propertyInt = propertyInt;
        }

        public long getPropertyLong() {
            return this.propertyLong;
        }

        public void setPropertyLong(long propertyLong) {
            this.propertyLong = propertyLong;
        }

        public double getPropertyDouble() {
            return this.propertyDouble;
        }

        public void setPropertyDouble(double propertyDouble) {
            this.propertyDouble = propertyDouble;
        }

        public boolean getPropertyBoolean() {
            return this.propertyBoolean;
        }

        public void setPropertyBoolean(boolean propertyBoolean) {
            this.propertyBoolean = propertyBoolean;
        }

        public String getC() {
            return this.c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }

    class AbstractMockContainerConfiguration {
        private String propertyInherited;

        AbstractMockContainerConfiguration() {
        }

        public String getPropertyInherited() {
            return this.propertyInherited;
        }

        public void setPropertyInherited(String propertyInherited) {
            this.propertyInherited = propertyInherited;
        }
    }

    class MockServiceLoader
    implements ServiceLoader {
        private Object instance;

        public MockServiceLoader(Object instance) {
            this.instance = instance;
        }

        public <T> Collection<T> all(Class<T> serviceClass) {
            if (serviceClass.isAssignableFrom(this.instance.getClass())) {
                return Collections.singleton(this.instance);
            }
            return Collections.emptyList();
        }

        public <T> T onlyOne(Class<T> serviceClass) {
            if (serviceClass.isAssignableFrom(this.instance.getClass())) {
                return (T)this.instance;
            }
            return null;
        }

        public <T> T onlyOne(Class<T> serviceClass, Class<? extends T> defaultServiceClass) {
            return this.onlyOne(serviceClass);
        }
    }
}

