/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.handler;

import junit.framework.Assert;
import org.jboss.arquillian.impl.DeploymentGenerator;
import org.jboss.arquillian.impl.context.ClassContext;
import org.jboss.arquillian.impl.context.SuiteContext;
import org.jboss.arquillian.impl.handler.ArchiveGenerator;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.event.suite.ClassEvent;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class ArchiveGeneratorTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeploymentGenerator generator;

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateExceptionOnMissingDeploymentGenerator() throws Exception {
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        ArchiveGenerator handler = new ArchiveGenerator();
        handler.callback((Context)context, new ClassEvent(new TestClass(this.getClass())));
    }

    @Test
    public void shouldGenerateArchive() throws Exception {
        final Archive deployment = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        TestClass testClass = new TestClass(this.getClass());
        ClassContext context = new ClassContext(new SuiteContext(this.serviceLoader));
        Mockito.when((Object)this.generator.generate(testClass)).thenAnswer(new Answer<Archive<?>>(){

            public Archive<?> answer(InvocationOnMock invocation) throws Throwable {
                return deployment;
            }
        });
        context.add(DeploymentGenerator.class, (Object)this.generator);
        ArchiveGenerator handler = new ArchiveGenerator();
        handler.callback((Context)context, new ClassEvent(testClass));
        Assert.assertNotNull((String)("Should have exported " + Archive.class.getSimpleName()), (Object)context.get(Archive.class));
    }
}

