/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.impl.DeploymentGenerator;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.ApplicationArchiveGenerator;
import org.jboss.arquillian.spi.ApplicationArchiveProcessor;
import org.jboss.arquillian.spi.AuxiliaryArchiveAppender;
import org.jboss.arquillian.spi.AuxiliaryArchiveProcessor;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDeploymentGenerator
implements DeploymentGenerator {
    private ServiceLoader serviceLoader;

    public ClientDeploymentGenerator(ServiceLoader serviceLoader) {
        Validate.notNull(serviceLoader, "ServiceLoader must be specified");
        this.serviceLoader = serviceLoader;
    }

    @Override
    public Archive<?> generate(TestClass testCase) {
        Validate.notNull(testCase, "TestCase must be specified");
        DeploymentPackager packager = (DeploymentPackager)this.serviceLoader.onlyOne(DeploymentPackager.class);
        Archive applicationArchive = ((ApplicationArchiveGenerator)this.serviceLoader.onlyOne(ApplicationArchiveGenerator.class)).generateApplicationArchive(testCase);
        this.applyApplicationProcessors(applicationArchive, testCase);
        List<Archive<?>> auxiliaryArchives = this.loadAuxiliaryArchives();
        this.applyAuxiliaryProcessors(auxiliaryArchives);
        return packager.generateDeployment(new TestDeployment(applicationArchive, auxiliaryArchives));
    }

    private List<Archive<?>> loadAuxiliaryArchives() {
        ArrayList archives = new ArrayList();
        Collection archiveAppenders = this.serviceLoader.all(AuxiliaryArchiveAppender.class);
        for (AuxiliaryArchiveAppender archiveAppender : archiveAppenders) {
            archives.add(archiveAppender.createAuxiliaryArchive());
        }
        return archives;
    }

    private void applyApplicationProcessors(Archive<?> applicationArchive, TestClass testClass) {
        Collection processors = this.serviceLoader.all(ApplicationArchiveProcessor.class);
        for (ApplicationArchiveProcessor processor : processors) {
            processor.process(applicationArchive, testClass);
        }
    }

    private void applyAuxiliaryProcessors(List<Archive<?>> auxiliaryArchives) {
        Collection processors = this.serviceLoader.all(AuxiliaryArchiveProcessor.class);
        for (AuxiliaryArchiveProcessor processor : processors) {
            for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
                processor.process(auxiliaryArchive);
            }
        }
    }
}

