/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.arquillian.impl.ConfigurationBuilder;
import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ConfigurationException;
import org.jboss.arquillian.spi.ContainerConfiguration;
import org.jboss.arquillian.spi.ServiceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationBuilder
implements ConfigurationBuilder {
    private static final Logger log = Logger.getLogger(XmlConfigurationBuilder.class.getName());
    private static final String DEFAULT_RESOURCE_PATH = "arquillian.xml";
    private String resourcePath;
    private ServiceLoader serviceLoader;

    public XmlConfigurationBuilder() {
        this(DEFAULT_RESOURCE_PATH);
    }

    public XmlConfigurationBuilder(String resourcePath) {
        this(resourcePath, new DynamicServiceLoader());
    }

    public XmlConfigurationBuilder(String resourcePath, ServiceLoader serviceLoader) {
        this.resourcePath = resourcePath;
        this.serviceLoader = serviceLoader;
    }

    @Override
    public Configuration build() throws ConfigurationException {
        Configuration configuration = new Configuration();
        Collection containersConfigurations = this.serviceLoader.all(ContainerConfiguration.class);
        log.fine("Container Configurations: " + containersConfigurations.size());
        for (ContainerConfiguration containerConfiguration : containersConfigurations) {
            configuration.addContainerConfig(containerConfiguration);
        }
        try {
            Document arquillianConfiguration = this.loadArquillianConfiguration(this.resourcePath);
            if (arquillianConfiguration != null) {
                this.populateConfiguration(arquillianConfiguration, containersConfigurations);
                this.populateConfiguration(arquillianConfiguration, configuration);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create configuration", (Throwable)e);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadArquillianConfiguration(String resourcePath) throws Exception {
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            inputStream = classLoader.getResourceAsStream(resourcePath);
            if (inputStream != null) {
                log.info("building configuration from XML file: " + resourcePath);
                Document document = this.getDocument(inputStream);
                return document;
            }
            log.fine("No " + resourcePath + " file found");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    private void populateConfiguration(Document xmlDocument, Collection<ContainerConfiguration> containersConfigurations) throws Exception {
        NodeList nodeList = xmlDocument.getDocumentElement().getElementsByTagNameNS("*", "container");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node containerNode = nodeList.item(i);
            String pkg = containerNode.getNamespaceURI().replaceFirst("urn:arq:", "");
            ContainerConfiguration containerConfig = this.matchContainerConfiguration(containersConfigurations, pkg);
            if (containerConfig == null) continue;
            this.mapNodesToProperties(containerConfig, containerNode);
        }
    }

    private void populateConfiguration(Document xmlDocument, Configuration configuration) throws Exception {
        NodeList nodeList = xmlDocument.getDocumentElement().getElementsByTagNameNS("*", "engine");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            this.mapNodesToProperties(configuration, node);
        }
    }

    private void mapNodesToProperties(Object configurationObject, Node xmlNode) throws Exception {
        Validate.notNull(configurationObject, "No ConfigurationObject specified");
        Validate.notNull(xmlNode, "No XML Node specified");
        log.fine("filling container configuration for class: " + configurationObject.getClass().getName());
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList childNodes = xmlNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            properties.putAll(this.getPropertiesFromNode(child));
        }
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method candidate : configurationObject.getClass().getMethods()) {
            String methodName = candidate.getName();
            if (!methodName.matches("^set[A-Z].*") || !candidate.getReturnType().equals(Void.TYPE) || candidate.getParameterTypes().length != 1) continue;
            candidate.setAccessible(true);
            setters.put(methodName.substring(3, 4).toLowerCase() + methodName.substring(4), candidate);
        }
        for (Map.Entry property : properties.entrySet()) {
            if (!setters.containsKey(property.getKey())) continue;
            Method method = (Method)setters.get(property.getKey());
            Object value = this.convert(method.getParameterTypes()[0], (String)property.getValue());
            method.invoke(configurationObject, value);
        }
    }

    private Map<String, String> getPropertiesFromNode(Node element) {
        HashMap<String, String> properties = new HashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        if (attributes.getLength() > 0) {
            new TagNameAttributeMapper().map(element, properties);
        } else {
            new TagNameMapper().map(element, properties);
        }
        return properties;
    }

    private ContainerConfiguration matchContainerConfiguration(Collection<ContainerConfiguration> containerConfigurations, String pkg) {
        log.fine("trying to match a container configuration for package: " + pkg);
        ContainerConfiguration containerConfig = null;
        for (ContainerConfiguration cc : containerConfigurations) {
            if (!cc.getClass().getName().startsWith(pkg)) continue;
            containerConfig = cc;
        }
        if (containerConfig == null) {
            log.warning("No container configuration found for URI: java:urn:" + pkg);
        }
        return containerConfig;
    }

    private Document getDocument(InputStream inputStream) throws Exception {
        Validate.notNull(inputStream, "No input stream specified");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(inputStream);
        document.getDocumentElement().normalize();
        return document;
    }

    private Object convert(Class<?> clazz, String value) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return Integer.valueOf(value);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return Double.valueOf(value);
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return Long.valueOf(value);
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TagNameMapper
    implements PropertiesMapper {
        private TagNameMapper() {
        }

        @Override
        public void map(Node element, Map<String, String> properties) {
            String value = "";
            if (!element.hasChildNodes()) {
                throw new ConfigurationException("Node " + element.getNodeName() + " has no value");
            }
            value = element.getChildNodes().item(0).getNodeValue();
            properties.put(element.getLocalName(), value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TagNameAttributeMapper
    implements PropertiesMapper {
        private TagNameAttributeMapper() {
        }

        @Override
        public void map(Node element, Map<String, String> properties) {
            NamedNodeMap attributes = element.getAttributes();
            for (int k = 0; k < attributes.getLength(); ++k) {
                Node attribute = attributes.item(k);
                String attributeName = attribute.getNodeName();
                String fullPropertyName = element.getLocalName() + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
                properties.put(fullPropertyName, attribute.getNodeValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PropertiesMapper {
        public void map(Node var1, Map<String, String> var2);
    }
}

