/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.UncheckedThrow;
import org.jboss.arquillian.impl.core.context.ClassContextImpl;
import org.jboss.arquillian.impl.core.context.ContainerContextImpl;
import org.jboss.arquillian.impl.core.context.DeploymentContextImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.context.TestContextImpl;
import org.jboss.arquillian.impl.core.spi.Manager;
import org.jboss.arquillian.impl.core.spi.context.ClassContext;
import org.jboss.arquillian.impl.core.spi.context.ContainerContext;
import org.jboss.arquillian.impl.core.spi.context.Context;
import org.jboss.arquillian.impl.core.spi.context.DeploymentContext;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.jboss.arquillian.impl.core.spi.context.TestContext;
import org.jboss.arquillian.spi.core.Injector;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.After;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagerTestBase {
    private ManagerImpl manager;

    @Before
    public final void create() {
        ManagerBuilder builder = ManagerBuilder.from();
        this.addContexts(builder);
        builder.extension(EventRegisterObserver.class);
        this.addExtensions(builder);
        this.manager = builder.create();
        ((Injector)this.manager.resolve(Injector.class)).inject((Object)this);
        this.startContexts((Manager)this.manager);
    }

    @After
    public final void destory() {
        this.manager.shutdown();
    }

    public ManagerImpl getManager() {
        return this.manager;
    }

    public final void fire(Object event) {
        this.manager.fire(event);
    }

    public final <T> void bind(Class<? extends Annotation> scope, Class<T> type, T instance) {
        this.manager.bind(scope, type, instance);
    }

    public final void assertEventFired(Class<?> type) {
        Assert.assertNotNull((String)("Event " + type.getName() + " should have been fired"), (Object)((EventRegister)this.manager.resolve(EventRegister.class)).getCount(type));
    }

    public final void assertEventFired(Class<?> type, Integer count) {
        Assert.assertEquals((String)("The event of exact type " + type.getName() + " should have been fired"), (Object)count, (Object)((EventRegister)this.manager.resolve(EventRegister.class)).getCount(type));
    }

    public final void assertEventFiredTyped(Class<?> type, Integer count) {
        Assert.assertEquals((String)("The event of assiganble type to " + type.getName() + " should have been fired"), (Object)count, (Object)((EventRegister)this.manager.resolve(EventRegister.class)).getCountTyped(type));
    }

    public final void assertEventFiredInContext(Class<?> type, Class<? extends Context> activeContext) {
        Assert.assertTrue((String)("Event " + type.getName() + " should have been fired within context " + activeContext.getName()), (boolean)((EventRegister)this.manager.resolve(EventRegister.class)).wasActive(type, activeContext));
    }

    protected void addContexts(ManagerBuilder builder) {
        builder.context(SuiteContextImpl.class).context(ClassContextImpl.class).context(TestContextImpl.class).context(ContainerContextImpl.class).context(DeploymentContextImpl.class);
    }

    protected abstract void addExtensions(ManagerBuilder var1);

    protected void startContexts(Manager manager) {
        ((SuiteContext)manager.getContext(SuiteContext.class)).activate();
        ((ClassContext)manager.getContext(ClassContext.class)).activate(super.getClass());
        ((TestContext)manager.getContext(TestContext.class)).activate((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventRecording {
        private Map<Class<? extends Context>, Boolean> activeContexts = new HashMap<Class<? extends Context>, Boolean>();

        public EventRecording add(Class<? extends Context> context, Boolean isActive) {
            this.activeContexts.put(context, isActive);
            return this;
        }

        public Boolean wasActive(Class<? extends Context> context) {
            if (this.activeContexts.get(context) != null) {
                return this.activeContexts.get(context);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventRegister {
        private Map<Class<?>, List<EventRecording>> events = new HashMap();

        public void add(Class<?> type, EventRecording recording) {
            if (this.events.get(type) == null) {
                ArrayList<EventRecording> recordings = new ArrayList<EventRecording>();
                recordings.add(recording);
                this.events.put(type, recordings);
            } else {
                this.events.get(type).add(recording);
            }
        }

        public Integer getCountTyped(Class<?> type) {
            int count = 0;
            for (Map.Entry<Class<?>, List<EventRecording>> recordingEntry : this.events.entrySet()) {
                if (!type.isAssignableFrom(recordingEntry.getKey())) continue;
                count += recordingEntry.getValue().size();
            }
            return count;
        }

        public Integer getCount(Class<?> type) {
            return this.events.containsKey(type) ? this.events.get(type).size() : 0;
        }

        public Boolean wasActive(Class<?> type, Class<? extends Context> context) {
            if (this.getCount(type) == 0) {
                return false;
            }
            for (EventRecording recording : this.events.get(type)) {
                if (recording.wasActive(context).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    public static class EventRegisterObserver {
        @Inject
        @ApplicationScoped
        private InstanceProducer<EventRegister> register;
        @Inject
        private Instance<SuiteContext> suiteContext;
        @Inject
        private Instance<ClassContext> classContext;
        @Inject
        private Instance<TestContext> testContext;
        @Inject
        private Instance<ContainerContext> containerContext;
        @Inject
        private Instance<DeploymentContext> deploymentContext;

        public void register(@Observes Object event) {
            if (this.register.get() == null) {
                this.register.set((Object)new EventRegister());
            }
            EventRegister reg = (EventRegister)this.register.get();
            reg.add(event.getClass(), new EventRecording().add(SuiteContext.class, ((SuiteContext)this.suiteContext.get()).isActive()).add(ClassContext.class, ((ClassContext)this.classContext.get()).isActive()).add(TestContext.class, ((TestContext)this.testContext.get()).isActive()).add(ContainerContext.class, ((ContainerContext)this.containerContext.get()).isActive()).add(DeploymentContext.class, ((DeploymentContext)this.deploymentContext.get()).isActive()));
            if (event instanceof Throwable) {
                UncheckedThrow.throwUnchecked((Throwable)((Throwable)event));
            }
        }
    }
}

