/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client;

import java.lang.reflect.Method;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.client.ContainerDeploymentContextHandler;
import org.jboss.arquillian.impl.client.ContainerEventController;
import org.jboss.arquillian.impl.client.container.event.DeployManagedDeployments;
import org.jboss.arquillian.impl.client.container.event.SetupContainers;
import org.jboss.arquillian.impl.client.container.event.StartManagedContainers;
import org.jboss.arquillian.impl.client.container.event.StopManagedContainers;
import org.jboss.arquillian.impl.client.container.event.UnDeployManagedDeployments;
import org.jboss.arquillian.impl.configuration.api.ContainerDef;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.spi.context.ContainerContext;
import org.jboss.arquillian.impl.core.spi.context.DeploymentContext;
import org.jboss.arquillian.impl.domain.ContainerRegistry;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.arquillian.spi.core.annotation.ClassScoped;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.jboss.arquillian.spi.event.suite.After;
import org.jboss.arquillian.spi.event.suite.AfterClass;
import org.jboss.arquillian.spi.event.suite.AfterSuite;
import org.jboss.arquillian.spi.event.suite.Before;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.arquillian.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.spi.event.suite.Test;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class ContainerEventControllerTestCase
extends AbstractManagerTestBase {
    private static final String CONTAINER_1_NAME = "container_1";
    private static final String DEPLOYMENT_1_NAME = "deployment_1";
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ContainerDef container1;
    @Mock
    private DeployableContainer deployableContainer1;
    private ContainerRegistry registry = new ContainerRegistry();
    private DeploymentScenario scenario = new DeploymentScenario();

    @Override
    protected void addExtensions(ManagerBuilder builder) {
        builder.extensions(new Class[]{ContainerEventController.class, ContainerDeploymentContextHandler.class});
    }

    @org.junit.Before
    public void scenario() throws Exception {
        Mockito.when((Object)this.container1.getContainerName()).thenReturn((Object)CONTAINER_1_NAME);
        Mockito.when((Object)this.serviceLoader.onlyOne((ClassLoader)Matchers.isA(ClassLoader.class), (Class)Matchers.eq(DeployableContainer.class))).thenReturn((Object)this.deployableContainer1);
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class);
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_1_NAME, archive).setTarget(new TargetDescription(CONTAINER_1_NAME)));
        this.registry.create(this.container1, this.serviceLoader);
        this.bind(SuiteScoped.class, ContainerRegistry.class, this.registry);
        this.bind(ClassScoped.class, DeploymentScenario.class, this.scenario);
    }

    @org.junit.Test
    public void shouldSetupAndStartContainers() throws Exception {
        this.fire(new BeforeSuite());
        this.assertEventFired(SetupContainers.class, 1);
        this.assertEventFired(StartManagedContainers.class, 1);
    }

    @org.junit.Test
    public void shouldStopContainers() throws Exception {
        this.fire(new AfterSuite());
        this.assertEventFired(StopManagedContainers.class, 1);
    }

    @org.junit.Test
    public void shouldDeployManagedDeployments() throws Exception {
        this.fire(new BeforeClass(this.testClass()));
        this.assertEventFired(DeployManagedDeployments.class, 1);
    }

    @org.junit.Test
    public void shouldUnDeployManagedDeployments() throws Exception {
        this.fire(new AfterClass(this.testClass()));
        this.assertEventFired(UnDeployManagedDeployments.class, 1);
    }

    @org.junit.Test
    public void shouldInvokeBeforeInContainerDeploymentContext() throws Exception {
        this.fire(new Before((Object)this, this.testMethod()));
        this.assertEventFiredInContext(Before.class, ContainerContext.class);
        this.assertEventFiredInContext(Before.class, DeploymentContext.class);
    }

    @org.junit.Test
    public void shouldInvokeTestInContainerDeploymentContext() throws Exception {
        this.fire(new Test(new TestMethodExecutor(){

            public void invoke(Object ... parameters) throws Throwable {
            }

            public Method getMethod() {
                return ContainerEventControllerTestCase.this.testMethod();
            }

            public Object getInstance() {
                return ContainerEventControllerTestCase.this;
            }
        }));
        this.assertEventFiredInContext(Test.class, ContainerContext.class);
        this.assertEventFiredInContext(Test.class, DeploymentContext.class);
    }

    @org.junit.Test
    public void shouldInvokeAfterInContainerDeploymentContext() throws Exception {
        this.fire(new After((Object)this, this.testMethod()));
        this.assertEventFiredInContext(After.class, ContainerContext.class);
        this.assertEventFiredInContext(After.class, DeploymentContext.class);
    }

    @org.junit.Test
    @Ignore
    public void shouldEnrichTestInstance() throws Exception {
        this.fire(new Before(this.testClass(), this.testMethod()));
    }

    private Class<?> testClass() {
        return ContainerEventControllerTestCase.class;
    }

    private Method testMethod() {
        try {
            return ContainerEventControllerTestCase.class.getDeclaredMethod("testMethod", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

