/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.client.ContainerDeploymentContextHandler;
import org.jboss.arquillian.impl.client.container.ContainerDeployController;
import org.jboss.arquillian.impl.client.container.ContainerLifecycleControllerTestCase;
import org.jboss.arquillian.impl.client.container.event.DeployDeployment;
import org.jboss.arquillian.impl.client.container.event.DeployManagedDeployments;
import org.jboss.arquillian.impl.client.container.event.UnDeployDeployment;
import org.jboss.arquillian.impl.client.container.event.UnDeployManagedDeployments;
import org.jboss.arquillian.impl.configuration.api.ContainerDef;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.spi.context.ContainerContext;
import org.jboss.arquillian.impl.core.spi.context.DeploymentContext;
import org.jboss.arquillian.impl.domain.ContainerRegistry;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.container.DeploymentException;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.arquillian.spi.core.annotation.ClassScoped;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.jboss.arquillian.spi.event.container.AfterDeploy;
import org.jboss.arquillian.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.spi.event.container.BeforeUnDeploy;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerDeployControllerTestCase
extends AbstractManagerTestBase {
    private static final String CONTAINER_1_NAME = "container_1";
    private static final String CONTAINER_2_NAME = "container_2";
    private static final String DEPLOYMENT_1_NAME = "deployment_1";
    private static final String DEPLOYMENT_2_NAME = "deployment_2";
    private static final String DEPLOYMENT_3_NAME = "deployment_3_manual";
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ContainerDef container1;
    @Mock
    private ContainerDef container2;
    @Mock
    private DeployableContainer deployableContainer1;
    @Mock
    private DeployableContainer deployableContainer2;
    @Mock
    private ProtocolMetaData protocolMetaData;
    private ContainerRegistry registry;
    private DeploymentScenario scenario;

    public ContainerDeployControllerTestCase() {
        ManagerImpl.DEBUG = false;
        this.registry = new ContainerRegistry();
        this.scenario = new DeploymentScenario();
    }

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.deployableContainer1.deploy((Archive)Matchers.isA(Archive.class))).thenReturn((Object)this.protocolMetaData);
        Mockito.when((Object)this.deployableContainer1.getConfigurationClass()).thenReturn(ContainerLifecycleControllerTestCase.DummyContainerConfiguration.class);
        Mockito.when((Object)this.deployableContainer2.deploy((Archive)Matchers.isA(Archive.class))).thenReturn((Object)this.protocolMetaData);
        Mockito.when((Object)this.deployableContainer2.getConfigurationClass()).thenReturn(ContainerLifecycleControllerTestCase.DummyContainerConfiguration.class);
        Mockito.when((Object)this.serviceLoader.onlyOne((ClassLoader)Matchers.isA(ClassLoader.class), (Class)Matchers.eq(DeployableContainer.class))).thenReturn((Object)this.deployableContainer1, (Object[])new DeployableContainer[]{this.deployableContainer2});
        Mockito.when((Object)this.container1.getContainerName()).thenReturn((Object)CONTAINER_1_NAME);
        Mockito.when((Object)this.container2.getContainerName()).thenReturn((Object)CONTAINER_2_NAME);
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class);
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_1_NAME, archive).setTarget(new TargetDescription(CONTAINER_1_NAME)));
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_2_NAME, archive).setTarget(new TargetDescription(CONTAINER_2_NAME)).setTestableArchive(archive));
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_3_NAME, archive).setTarget(new TargetDescription(CONTAINER_2_NAME)).shouldBeManaged(false));
        this.bind(SuiteScoped.class, ContainerRegistry.class, this.registry);
        this.bind(ClassScoped.class, DeploymentScenario.class, this.scenario);
    }

    protected void addExtensions(ManagerBuilder builder) {
        builder.extensions(new Class[]{ContainerDeployController.class, ContainerDeploymentContextHandler.class});
    }

    @Test
    public void shouldDeployAllManagedDeployments() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.fire(new DeployManagedDeployments());
        this.assertEventFired(DeployDeployment.class, 2);
        this.assertEventFiredInContext(DeployDeployment.class, ContainerContext.class);
        this.assertEventFiredInContext(DeployDeployment.class, DeploymentContext.class);
        this.assertEventFired(BeforeDeploy.class, 2);
        this.assertEventFiredInContext(BeforeDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(BeforeDeploy.class, DeploymentContext.class);
        this.assertEventFired(AfterDeploy.class, 2);
        this.assertEventFiredInContext(AfterDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(AfterDeploy.class, DeploymentContext.class);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer1, (VerificationMode)Mockito.times((int)1))).deploy((Archive)Matchers.isA(Archive.class));
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer2, (VerificationMode)Mockito.times((int)1))).deploy((Archive)Matchers.isA(Archive.class));
    }

    @Test
    public void shouldUnDeployAllManagedDeployments() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.fire(new UnDeployManagedDeployments());
        this.assertEventFired(UnDeployDeployment.class, 2);
        this.assertEventFiredInContext(UnDeployDeployment.class, ContainerContext.class);
        this.assertEventFiredInContext(UnDeployDeployment.class, DeploymentContext.class);
        this.assertEventFired(BeforeUnDeploy.class, 2);
        this.assertEventFiredInContext(BeforeUnDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(BeforeUnDeploy.class, DeploymentContext.class);
        this.assertEventFired(AfterUnDeploy.class, 2);
        this.assertEventFiredInContext(AfterUnDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(AfterUnDeploy.class, DeploymentContext.class);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer1, (VerificationMode)Mockito.times((int)1))).undeploy((Archive)Matchers.isA(Archive.class));
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer2, (VerificationMode)Mockito.times((int)1))).undeploy((Archive)Matchers.isA(Archive.class));
    }

    @Test
    public void shouldCatchExceptionInDeploymentContext() throws Exception {
        block2: {
            this.registry.create(this.container1, this.serviceLoader);
            this.registry.create(this.container2, this.serviceLoader);
            Mockito.when((Object)this.deployableContainer1.deploy((Archive)Matchers.isA(Archive.class))).thenThrow(new Throwable[]{new DeploymentException("_TEST_")});
            try {
                this.fire(new DeployManagedDeployments());
            }
            catch (Exception e) {
                if (e instanceof DeploymentException) break block2;
                throw e;
            }
        }
        this.assertEventFired(DeploymentException.class, 1);
        this.assertEventFiredInContext(DeploymentException.class, ContainerContext.class);
        this.assertEventFiredInContext(DeploymentException.class, DeploymentContext.class);
        this.assertEventFiredTyped(Throwable.class, 1);
    }
}

