/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.client.ContainerDeploymentContextHandler;
import org.jboss.arquillian.impl.client.container.ContainerLifecycleController;
import org.jboss.arquillian.impl.client.container.event.SetupContainer;
import org.jboss.arquillian.impl.client.container.event.SetupContainers;
import org.jboss.arquillian.impl.client.container.event.StartContainer;
import org.jboss.arquillian.impl.client.container.event.StartManagedContainers;
import org.jboss.arquillian.impl.client.container.event.StopContainer;
import org.jboss.arquillian.impl.client.container.event.StopManagedContainers;
import org.jboss.arquillian.impl.configuration.api.ContainerDef;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.spi.context.ContainerContext;
import org.jboss.arquillian.impl.domain.ContainerRegistry;
import org.jboss.arquillian.spi.ConfigurationException;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.jboss.arquillian.spi.event.container.AfterSetup;
import org.jboss.arquillian.spi.event.container.AfterStart;
import org.jboss.arquillian.spi.event.container.AfterStop;
import org.jboss.arquillian.spi.event.container.BeforeSetup;
import org.jboss.arquillian.spi.event.container.BeforeStart;
import org.jboss.arquillian.spi.event.container.BeforeStop;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerLifecycleControllerTestCase
extends AbstractManagerTestBase {
    private static final String CONTAINER_1_NAME = "container_1";
    private static final String CONTAINER_2_NAME = "container_2";
    private ContainerRegistry registry = new ContainerRegistry();
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ContainerDef container1;
    @Mock
    private ContainerDef container2;
    @Mock
    private DeployableContainer deployableContainer;

    @Before
    public void setup() {
        Mockito.when((Object)this.deployableContainer.getConfigurationClass()).thenReturn(DummyContainerConfiguration.class);
        Mockito.when((Object)this.serviceLoader.onlyOne((ClassLoader)Matchers.isA(ClassLoader.class), (Class)Matchers.eq(DeployableContainer.class))).thenReturn((Object)this.deployableContainer);
        Mockito.when((Object)this.container1.getContainerName()).thenReturn((Object)CONTAINER_1_NAME);
        Mockito.when((Object)this.container2.getContainerName()).thenReturn((Object)CONTAINER_2_NAME);
        this.bind(SuiteScoped.class, ContainerRegistry.class, this.registry);
    }

    protected void addExtensions(ManagerBuilder builder) {
        builder.extensions(new Class[]{ContainerLifecycleController.class, ContainerDeploymentContextHandler.class});
    }

    @Test
    public void shouldSetupAllContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.fire(new SetupContainers());
        this.assertEventFiredInContext(SetupContainer.class, ContainerContext.class);
        this.assertEventFired(SetupContainer.class, 2);
        this.assertEventFiredInContext(BeforeSetup.class, ContainerContext.class);
        this.assertEventFired(BeforeSetup.class, 2);
        this.assertEventFiredInContext(AfterSetup.class, ContainerContext.class);
        this.assertEventFired(AfterSetup.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).setup((ContainerConfiguration)Matchers.isA(DummyContainerConfiguration.class));
    }

    @Test
    public void shouldStartAllContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.fire(new StartManagedContainers());
        this.assertEventFiredInContext(StartContainer.class, ContainerContext.class);
        this.assertEventFired(StartContainer.class, 2);
        this.assertEventFiredInContext(BeforeStart.class, ContainerContext.class);
        this.assertEventFired(BeforeStart.class, 2);
        this.assertEventFiredInContext(AfterStart.class, ContainerContext.class);
        this.assertEventFired(AfterStart.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).start();
    }

    @Test
    public void shouldStopAllContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.fire(new StopManagedContainers());
        this.assertEventFiredInContext(StopContainer.class, ContainerContext.class);
        this.assertEventFired(StopContainer.class, 2);
        this.assertEventFiredInContext(BeforeStop.class, ContainerContext.class);
        this.assertEventFired(BeforeStop.class, 2);
        this.assertEventFiredInContext(AfterStop.class, ContainerContext.class);
        this.assertEventFired(AfterStop.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).stop();
    }

    public static class DummyContainerConfiguration
    implements ContainerConfiguration {
        public void validate() throws ConfigurationException {
        }
    }
}

