/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.client.container.ContainerRestarter;
import org.jboss.arquillian.impl.client.container.event.StartManagedContainers;
import org.jboss.arquillian.impl.client.container.event.StopManagedContainers;
import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.impl.configuration.api.EngineDef;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.event.suite.BeforeClass;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerRestarterTestCase
extends AbstractManagerTestBase {
    protected void addExtensions(ManagerBuilder builder) {
        builder.extension(ContainerRestarter.class);
    }

    @Test
    public void shouldRestartContainerForEveryX() throws Exception {
        EngineDef desc = ((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).engine().maxTestClassesBeforeRestart(Integer.valueOf(5));
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, desc);
        for (int i = 0; i < 10; ++i) {
            this.fire(new BeforeClass(this.getClass()));
        }
        this.assertEventFired(StartManagedContainers.class, 2);
        this.assertEventFired(StopManagedContainers.class, 2);
    }

    @Test
    public void shouldNotForceRestartIfMaxDeploymentsNotSet() throws Exception {
        EngineDef desc = ((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).engine();
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, desc);
        for (int i = 0; i < 10; ++i) {
            this.fire(new BeforeClass(this.getClass()));
        }
        this.assertEventFired(StartManagedContainers.class, 0);
        this.assertEventFired(StopManagedContainers.class, 0);
    }
}

