/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import java.util.Arrays;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.client.container.DeploymentExceptionHandler;
import org.jboss.arquillian.impl.client.container.event.DeployDeployment;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.container.DeploymentException;
import org.jboss.arquillian.spi.client.container.DeploymentExceptionTransformer;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentExceptionHandlerTestCase
extends AbstractManagerTestBase {
    @Inject
    @ApplicationScoped
    private InstanceProducer<ServiceLoader> serviceProducer;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeploymentExceptionTransformer transformer;
    @Mock
    private Container container;

    protected void addExtensions(ManagerBuilder builder) {
        builder.extensions(new Class[]{DeploymentExceptionHandler.class, TestExceptionDeployThrower.class});
    }

    @Before
    public void registerServiceLoader() {
        this.serviceProducer.set((Object)this.serviceLoader);
    }

    @Test
    public void shouldSwallowExceptionIfExpected() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new NullPointerException());
        this.fire(new DeployDeployment(this.container, new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(NullPointerException.class)));
    }

    @Test
    public void shouldCallDeploymentTransformers() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new IllegalArgumentException());
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        this.fire(new DeployDeployment(this.container, new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class)));
        ((DeploymentExceptionTransformer)Mockito.verify((Object)this.transformer, (VerificationMode)Mockito.times((int)1))).transform((Throwable)Mockito.isA(Exception.class));
    }

    @Test
    public void shouldTransformException() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new IllegalStateException();
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        Mockito.when((Object)this.transformer.transform(TestExceptionDeployThrower.shouldThrow)).thenReturn((Object)new IllegalArgumentException());
        this.fire(new DeployDeployment(this.container, new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class)));
    }

    @Test(expected=DeploymentException.class)
    public void shouldRethrowExceptionIfWrongExpectedType() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new NullPointerException());
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        this.fire(new DeployDeployment(this.container, new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class)));
    }

    @Test(expected=DeploymentException.class)
    public void shouldRethrowExceptionIfExpectedNotSet() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new NullPointerException());
        this.fire(new DeployDeployment(this.container, new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class))));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionIfExpectedButNoExceptionThrown() throws Exception {
        TestExceptionDeployThrower.shouldThrow = null;
        this.fire(new DeployDeployment(this.container, new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class)));
    }

    public static class TestExceptionDeployThrower {
        public static Throwable shouldThrow = null;

        public void throwException(@Observes DeployDeployment event) throws Throwable {
            if (shouldThrow != null) {
                throw shouldThrow;
            }
        }
    }
}

