/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.deployment;

import junit.framework.Assert;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.api.OverProtocol;
import org.jboss.arquillian.api.ShouldThrowException;
import org.jboss.arquillian.api.TargetsContainer;
import org.jboss.arquillian.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class AnnotationDeploymentScenarioGeneratorTestCase {
    @Test
    public void shouldHandleMultipleDeploymentsAllDefault() throws Exception {
        DeploymentScenario scenario = new AnnotationDeploymentScenarioGenerator().generate(new TestClass(MultiDeploymentsDefault.class));
        Assert.assertNotNull((Object)scenario);
        Assert.assertEquals((String)"Verify all deployments were found", (int)2, (int)scenario.getDeployments().size());
        for (DeploymentDescription deployment : scenario.getDeployments()) {
            Assert.assertEquals((String)"Verify deployment has default target", (Object)TargetDescription.DEFAULT, (Object)deployment.getTarget());
            Assert.assertEquals((String)"Verify deployment has default protocol", (Object)ProtocolDescription.DEFAULT, (Object)deployment.getProtocol());
            Assert.assertEquals((int)-1, (int)deployment.getOrder());
            Assert.assertEquals((boolean)true, (boolean)deployment.managed());
            Assert.assertTrue((boolean)JavaArchive.class.isInstance(deployment.getArchive()));
        }
    }

    @Test
    public void shouldHandleMultipleDeploymentsAllSet() throws Exception {
        DeploymentScenario scenario = new AnnotationDeploymentScenarioGenerator().generate(new TestClass(MultiDeploymentsSet.class));
        Assert.assertNotNull((Object)scenario);
        Assert.assertEquals((String)"Verify all deployments were found", (int)2, (int)scenario.getDeployments().size());
        DeploymentDescription deploymentOne = (DeploymentDescription)scenario.getDeployments().get(0);
        Assert.assertEquals((String)"Verify deployment has specified target", (Object)new TargetDescription("target-first"), (Object)deploymentOne.getTarget());
        Assert.assertEquals((String)"Verify deployment has specified protocol", (Object)new ProtocolDescription("protocol-first"), (Object)deploymentOne.getProtocol());
        Assert.assertEquals((int)1, (int)deploymentOne.getOrder());
        Assert.assertEquals((boolean)false, (boolean)deploymentOne.managed());
        Assert.assertEquals((boolean)false, (boolean)deploymentOne.testable());
        Assert.assertTrue((boolean)JavaArchive.class.isInstance(deploymentOne.getArchive()));
        Assert.assertNull((Object)deploymentOne.getExpectedException());
        DeploymentDescription deploymentTwo = (DeploymentDescription)scenario.getDeployments().get(1);
        Assert.assertEquals((String)"Verify deployment has specified target", (Object)new TargetDescription("target-second"), (Object)deploymentTwo.getTarget());
        Assert.assertEquals((String)"Verify deployment has specified protocol", (Object)new ProtocolDescription("protocol-second"), (Object)deploymentTwo.getProtocol());
        Assert.assertEquals((int)2, (int)deploymentTwo.getOrder());
        Assert.assertEquals((boolean)false, (boolean)deploymentTwo.managed());
        Assert.assertEquals((boolean)true, (boolean)deploymentTwo.testable());
        Assert.assertTrue((boolean)JavaArchive.class.isInstance(deploymentTwo.getArchive()));
        Assert.assertNull((Object)deploymentTwo.getExpectedException());
    }

    @Test
    public void shouldReadExpectedAndOverrideDeployment() {
        DeploymentScenario scenario = new AnnotationDeploymentScenarioGenerator().generate(new TestClass(ExpectedDeploymentExceptionSet.class));
        Assert.assertNotNull((Object)scenario);
        Assert.assertEquals((String)"Verify all deployments were found", (int)1, (int)scenario.getDeployments().size());
        DeploymentDescription deploymentOne = (DeploymentDescription)scenario.getDeployments().get(0);
        Assert.assertEquals((boolean)false, (boolean)deploymentOne.testable());
        Assert.assertTrue((boolean)JavaArchive.class.isInstance(deploymentOne.getArchive()));
        Assert.assertEquals(Exception.class, (Object)deploymentOne.getExpectedException());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentNotPresent() throws Exception {
        new AnnotationDeploymentScenarioGenerator().generate(new TestClass(DeploymentNotPresent.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentNotStatic() throws Exception {
        new AnnotationDeploymentScenarioGenerator().generate(new TestClass(DeploymentNotStatic.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnDeploymentWrongReturnType() throws Exception {
        new AnnotationDeploymentScenarioGenerator().generate(new TestClass(DeploymentWrongReturnType.class));
    }

    private static class DeploymentWrongReturnType {
        private DeploymentWrongReturnType() {
        }

        @Deployment
        public Object test() {
            return ShrinkWrap.create(JavaArchive.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentNotStatic {
        private DeploymentNotStatic() {
        }

        @Deployment
        public Archive<?> test() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    private static class DeploymentNotPresent {
        private DeploymentNotPresent() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpectedDeploymentExceptionSet {
        private ExpectedDeploymentExceptionSet() {
        }

        @Deployment(name="second", testable=true)
        @ShouldThrowException(value=Exception.class)
        public static Archive<?> deploymentOne() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiDeploymentsSet {
        private MultiDeploymentsSet() {
        }

        @OverProtocol(value="protocol-first")
        @TargetsContainer(value="target-first")
        @Deployment(name="first", order=1, managed=false, testable=false)
        public static Archive<?> deploymentOne() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }

        @OverProtocol(value="protocol-second")
        @TargetsContainer(value="target-second")
        @Deployment(name="second", order=2, managed=false)
        public static Archive<?> deploymentTwo() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiDeploymentsDefault {
        private MultiDeploymentsDefault() {
        }

        @Deployment
        public static Archive<?> deploymentOne() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }

        @Deployment
        public static Archive<?> deploymentTwo() {
            return (Archive)ShrinkWrap.create(JavaArchive.class);
        }
    }
}

