/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.deployment;

import java.io.File;
import junit.framework.Assert;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.client.deployment.ArchiveDeploymentExporter;
import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.event.container.BeforeDeploy;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArchiveDeploymentExporterTestCase
extends AbstractManagerTestBase {
    private static final String ARQUILLIAN_DEPLOYMENT_EXPORT_PATH = "arquillian.deploymentExportPath";
    private static final String TARGET_NAME = "test.jar";
    private static final String DEPLOYMENT_NAME = "test.jar";
    private static final String ARCHIVE_NAME = "test.jar";
    private static final String EXPORT_PATH = "target/";
    @Mock
    private DeployableContainer<?> deployableContainer;
    @Mock
    private DeploymentDescription deployment;

    protected void addExtensions(ManagerBuilder builder) {
        builder.extension(ArchiveDeploymentExporter.class);
    }

    @Before
    public void createDeployment() {
        Archive archive = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClass(this.getClass());
        this.deployment = new DeploymentDescription("test.jar", archive);
        this.deployment.setTarget(new TargetDescription("test.jar"));
        this.deployment.setTestableArchive(archive);
    }

    @Test
    public void shouldHandleNoConfigurationInContext() throws Exception {
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExportIfExportPathSystemPropertyIsSet() throws Exception {
        System.setProperty(ARQUILLIAN_DEPLOYMENT_EXPORT_PATH, EXPORT_PATH);
        try {
            this.bind(ApplicationScoped.class, ArquillianDescriptor.class, Descriptors.create(ArquillianDescriptor.class));
            this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
            this.fileShouldExist(true);
        }
        finally {
            System.setProperty(ARQUILLIAN_DEPLOYMENT_EXPORT_PATH, "");
        }
    }

    @Test
    public void shouldNotExportIfDeploymentExportPathNotSet() throws Exception {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, Descriptors.create(ArquillianDescriptor.class));
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldNotExportedIfDeploymentIsNotArchive() throws Exception {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, ((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).engine().deploymentExportPath(EXPORT_PATH));
        this.deployment = new DeploymentDescription("test.jar", Descriptors.create(WebAppDescriptor.class));
        this.deployment.setTarget(new TargetDescription("test.jar"));
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldBeExportedWhenDeploymentExportPathIsSet() throws Exception {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, ((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).engine().deploymentExportPath(EXPORT_PATH));
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(true);
    }

    private void fileShouldExist(boolean bol) {
        File file = new File("target/test.jar_test.jar_test.jar");
        Assert.assertEquals((String)"File exists", (boolean)bol, (boolean)file.exists());
        file.delete();
    }
}

