/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.protocol;

import java.util.Arrays;
import org.jboss.arquillian.impl.client.protocol.ProtocolRegistryCreator;
import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.jboss.arquillian.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.protocol.Protocol;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProtocolRegistryCreatorTestCase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private Protocol<?> protocol;
    private ManagerImpl manager;

    @Before
    public void create() throws Exception {
        this.manager = ManagerBuilder.from().context(SuiteContextImpl.class).extension(ProtocolRegistryCreator.class).create();
        ((SuiteContext)this.manager.getContext(SuiteContext.class)).activate();
        ((SuiteContext)this.manager.getContext(SuiteContext.class)).getObjectStore().add(ServiceLoader.class, (Object)this.serviceLoader);
    }

    @After
    public void destroy() throws Exception {
        ((SuiteContext)this.manager.getContext(SuiteContext.class)).deactivate();
        ((SuiteContext)this.manager.getContext(SuiteContext.class)).destroy();
    }

    @Test
    public void shouldBindProtocolRegistryToContext() throws Exception {
        this.manager.fire((Object)this.createDescriptor());
        Assert.assertNotNull((String)("Verify " + ProtocolRegistry.class.getSimpleName() + " was bound to context"), (Object)this.manager.resolve(ProtocolRegistry.class));
    }

    @Test
    public void shouldBindFoundProtocolsToRegistry() throws Exception {
        String protocolName = "protocol";
        Mockito.when((Object)this.protocol.getDescription()).thenReturn((Object)new ProtocolDescription(protocolName));
        Mockito.when((Object)this.serviceLoader.all(Protocol.class)).thenReturn(Arrays.asList(this.protocol));
        this.manager.fire((Object)this.createDescriptor());
        ProtocolRegistry registry = (ProtocolRegistry)this.manager.resolve(ProtocolRegistry.class);
        ProtocolDefinition registeredProtocol = registry.getProtocol(new ProtocolDescription(protocolName));
        Assert.assertNotNull((String)("Verify " + Protocol.class.getSimpleName() + " was registered"), (Object)registeredProtocol);
        Assert.assertEquals((String)"Verify same protocol instance was registered", this.protocol, (Object)registeredProtocol.getProtocol());
    }

    private ArquillianDescriptor createDescriptor() {
        return (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
    }
}

