/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.configuration.api;

import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.impl.configuration.api.AssertXPath;
import org.jboss.arquillian.impl.configuration.api.GroupDef;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ArquillianDescriptorTestCase {
    private static final String CONTAINER_NAME_1 = "jbossas-remote";
    private static final String CONTAINER_NAME_2 = "jbossas-embedded";
    private static final String CONTAINER_NAME_3 = "jbossas-managed";
    private static final String CONTAINER_NAME_4 = "jbossas-cloud";
    private static final String PROTOCOL_TYPE_1 = "Servlet 3.0";
    private static final String PROTOCOL_TYPE_2 = "Servlet 2.5";
    private static final String PROTOCOL_TYPE_3 = "EJB 3.0";
    private static final String GROUP_NAME_1 = "jbossas-remote-group";
    private static final String GROUP_NAME_2 = "jbossas-embedded-group";
    private static final String DEPENDENCY_1 = "org.test:test";
    private static final String DEPENDENCY_2 = "org.test:test2";
    private static final String EXTENSION_NAME_1 = "selenium";
    private static final String EXTENSION_NAME_2 = "performance";
    private static final String PROPERTY_NAME_1 = "test-name";
    private static final String PROPERTY_VALUE_1 = "test-value";
    private static final String PROPERTY_NAME_2 = "test2-name";
    private static final String PROPERTY_VALUE_2 = "test2-value";
    private static final String PROPERTY_NAME_3 = "test3-name";
    private static final String PROPERTY_VALUE_3 = "test3-value";
    private static final Integer PROPERTY_INT_VALUE_1 = 10;
    private String desc;

    @After
    public void print() {
        System.out.println(this.desc);
    }

    @Test
    public void shouldBeAbleToGenerateEmpty() throws Exception {
        this.desc = this.create().exportAsString();
    }

    @Test
    public void shouldBeAbleToSetEngineProperties() throws Exception {
        this.desc = this.create().engine().deploymentExportPath(PROPERTY_VALUE_1).deploymentExportPath(PROPERTY_VALUE_1).maxTestClassesBeforeRestart(PROPERTY_INT_VALUE_1).maxTestClassesBeforeRestart(PROPERTY_INT_VALUE_1).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/engine/property[@name='deploymentExportPath']/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/engine/property[@name='maxTestClassesBeforeRestart']/text()", PROPERTY_INT_VALUE_1);
        ArquillianDescriptor descriptor = (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).from(this.desc);
        Assert.assertEquals((Object)PROPERTY_VALUE_1, (Object)descriptor.engine().getDeploymentExportPath());
        Assert.assertEquals((Object)PROPERTY_INT_VALUE_1, (Object)descriptor.engine().getMaxTestClassesBeforeRestart());
    }

    @Test
    public void shouldBeAbleToAddContainer() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).setDefault().container(CONTAINER_NAME_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@qualifier", CONTAINER_NAME_1, CONTAINER_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/@default", "true");
    }

    @Test
    public void shouldBeAbleToAddDefaultProtocol() throws Exception {
        this.desc = this.create().defaultProtocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/protocol/@type", PROTOCOL_TYPE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/protocol/configuration/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/protocol/configuration/property/text()", PROPERTY_VALUE_1);
    }

    @Test
    public void shouldBeAbleToAddContainerWithDependencies() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).dependency(DEPENDENCY_1).dependency(DEPENDENCY_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/dependencies/dependency", DEPENDENCY_1, DEPENDENCY_2);
    }

    @Test
    public void shouldBeAbleToAddContainerWithMultipleProtocols() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).protocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).protocol(PROTOCOL_TYPE_2).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@qualifier", CONTAINER_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[1]/@type", PROTOCOL_TYPE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[1]/configuration/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[1]/configuration/property/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[2]/@type", PROTOCOL_TYPE_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[2]/configuration/property/@name", PROPERTY_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[2]/configuration/property/text()", PROPERTY_VALUE_2);
    }

    @Test
    public void shouldBeAbleToAddContainerWithConfiguration() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).container(CONTAINER_NAME_2).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/@qualifier", CONTAINER_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/configuration/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/configuration/property/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[2]/@qualifier", CONTAINER_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[2]/configuration/property/@name", PROPERTY_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[2]/configuration/property/text()", PROPERTY_VALUE_2);
    }

    @Test
    public void shouldBeAbleToAddGroupWithContainer() throws Exception {
        this.desc = this.create().group(GROUP_NAME_1).container(CONTAINER_NAME_1).container(CONTAINER_NAME_2).group(GROUP_NAME_2).container(CONTAINER_NAME_3).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/group/@qualifier", GROUP_NAME_1, GROUP_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/group/container/@qualifier", CONTAINER_NAME_1, CONTAINER_NAME_2, CONTAINER_NAME_3);
        ArquillianDescriptor descriptor = (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).from(this.desc);
        Assert.assertEquals((long)2L, (long)descriptor.getGroups().size());
        Assert.assertEquals((long)2L, (long)((GroupDef)descriptor.getGroups().get(0)).getGroupContainers().size());
    }

    @Test
    public void shouldBeAbleToAddExtension() throws Exception {
        this.desc = this.create().extension(EXTENSION_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).extension(EXTENSION_NAME_2).property(PROPERTY_NAME_3, PROPERTY_VALUE_3).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/extension/@qualifier", EXTENSION_NAME_1, EXTENSION_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/configuration/property[1]/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/configuration/property[1]/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/configuration/property[2]/@name", PROPERTY_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/configuration/property[2]/text()", PROPERTY_VALUE_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[2]/configuration/property/@name", PROPERTY_NAME_3);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[2]/configuration/property/text()", PROPERTY_VALUE_3);
    }

    @Test
    public void shouldBeAbleToAddEverything() throws Exception {
        this.desc = this.create().defaultProtocol(PROTOCOL_TYPE_1).property(PROPERTY_VALUE_3, PROPERTY_VALUE_3).container(CONTAINER_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).dependency(DEPENDENCY_1).protocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).group(GROUP_NAME_1).container(CONTAINER_NAME_2).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).dependency(DEPENDENCY_2).protocol(PROTOCOL_TYPE_2).property(PROPERTY_NAME_3, PROPERTY_VALUE_3).group(GROUP_NAME_2).container(CONTAINER_NAME_3).protocol(PROTOCOL_TYPE_3).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).container(CONTAINER_NAME_4).extension(EXTENSION_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_2).exportAsString();
    }

    private ArquillianDescriptor create() {
        return (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
    }
}

