/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.io.IOException;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Assert;
import org.junit.Test;

public class EventFireTestCase {
    @Test
    public void shouldBeAbleToFireEventToAExtension() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extension(ExtensionWithObservers.class).create();
        manager.fire(new Object());
        Assert.assertTrue((boolean)((ExtensionWithObservers)manager.getExtension(ExtensionWithObservers.class)).methodOneWasCalled);
    }

    @Test
    public void shouldBeAbleToFireExceptionEventOnFailingObserver() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extensions(new Class[]{ExtensionWithExceptionObserver.class, ExtensionObservingException.class}).create();
        manager.fire((Object)new String("should cause exception"));
        Assert.assertTrue((boolean)((ExtensionObservingException)manager.getExtension(ExtensionObservingException.class)).methodOneWasCalled);
    }

    @Test(expected=IOException.class)
    public void shouldBeAbleToDetectExceptionEventLoopAndThrowOriginalException() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extensions(new Class[]{ExtensionObservingExceptionLoop.class}).create();
        manager.fire((Object)new IOException("should cause exception"));
    }

    private static class ExtensionObservingExceptionLoop {
        private ExtensionObservingExceptionLoop() {
        }

        public void methodOne(@Observes IOException exception) throws IOException {
            throw new IOException();
        }
    }

    private static class ExtensionObservingException {
        private boolean methodOneWasCalled = false;

        private ExtensionObservingException() {
        }

        public void methodOne(@Observes IllegalStateException exception) {
            this.methodOneWasCalled = true;
        }
    }

    private static class ExtensionWithExceptionObserver {
        private ExtensionWithExceptionObserver() {
        }

        public void methodOne(@Observes String object) {
            throw new IllegalStateException("Illegal state");
        }
    }

    private static class ExtensionWithObservers {
        private boolean methodOneWasCalled = false;

        private ExtensionWithObservers() {
        }

        public void methodOne(@Observes Object object) {
            this.methodOneWasCalled = true;
        }
    }
}

