/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import org.jboss.arquillian.impl.core.EventImpl;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.spi.Manager;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Assert;
import org.junit.Test;

public class EventImplTestCase {
    @Test
    public void shouldBeAbleToFireEvent() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extensions(new Class[]{TestObserver.class}).create();
        EventImpl event = EventImpl.of(Object.class, (Manager)manager);
        Object testObject = new Object();
        event.fire(testObject);
        TestObserver observer = (TestObserver)manager.getExtension(TestObserver.class);
        Assert.assertTrue((boolean)observer.wasCalled);
        Assert.assertEquals((String)"Verify same object was observed", (Object)testObject, (Object)observer.getObject());
    }

    private static class TestObserver {
        private boolean wasCalled = false;
        private Object object;

        private TestObserver() {
        }

        public void shouldBeCalled(@Observes Object object) {
            Assert.assertNotNull((Object)object);
            this.object = object;
            this.wasCalled = true;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

