/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import junit.framework.Assert;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.spi.core.Event;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Test;

public class ExceptionHandlingTestCase {
    public ExceptionHandlingTestCase() {
        ManagerImpl.DEBUG = false;
    }

    @Test
    public void shouldOnlyFireSameExceptionOnce() throws Exception {
        block2: {
            ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).extensions(new Class[]{TestEventFire.class, TestExceptionThrower.class, TestExceptionHandler.class}).create();
            try {
                manager.fire((Object)new Double(0.0));
            }
            catch (Exception e) {
                if (e instanceof TestException) break block2;
                Assert.fail((String)("Wrong Exception thrown " + e));
            }
        }
        Assert.assertEquals((Object)new Integer(1), (Object)TestEventFire.called);
        Assert.assertEquals((Object)new Integer(1), (Object)TestExceptionThrower.called);
        Assert.assertEquals((Object)new Integer(1), (Object)TestExceptionHandler.called);
    }

    public static class TestException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TestException(String message) {
            super(message);
        }
    }

    public static class TestExceptionHandler {
        public static Integer called = 0;

        public void handle(@Observes TestException event) throws Exception {
            Integer n = called;
            Integer n2 = called = Integer.valueOf(called + 1);
            throw event;
        }
    }

    public static class TestExceptionThrower {
        public static Integer called = 0;

        public void handle(@Observes Integer event) throws Exception {
            Integer n = called;
            Integer n2 = called = Integer.valueOf(called + 1);
            throw new TestException("_TEST_");
        }
    }

    public static class TestEventFire {
        public static Integer called = 0;
        @Inject
        private Event<Integer> integer;

        public void handle(@Observes Double event) throws Exception {
            Integer n = called;
            Integer n2 = called = Integer.valueOf(called + 1);
            this.integer.fire((Object)new Integer(10));
        }
    }
}

