/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Assert;
import org.junit.Test;

public class ExtensionOrderTestCase {
    private static List<String> callOrder = new ArrayList<String>();

    @Test
    public void shouldExecuteProducersOnSameEventBeforeConsumers() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extensions(new Class[]{ConsumerOne.class, ProducerOne.class, ProducerTwo.class}).create();
        manager.fire((Object)"test");
        Assert.assertEquals((Object)"ProducerOne", (Object)callOrder.get(0));
        Assert.assertEquals((Object)"ProducerTwo", (Object)callOrder.get(1));
        Assert.assertEquals((Object)"ConsumerOne", (Object)callOrder.get(2));
    }

    private static class ValueTwo {
        private ValueTwo() {
        }
    }

    private static class ValueOne {
        private ValueOne() {
        }
    }

    public static class ConsumerOne {
        public void exec(@Observes String ba) {
            callOrder.add(this.getClass().getSimpleName());
        }
    }

    public static class ProducerTwo {
        @Inject
        @ApplicationScoped
        private InstanceProducer<ValueTwo> value;

        public void exec(@Observes(precedence=10) String ba) {
            callOrder.add(this.getClass().getSimpleName());
            this.value.set((Object)new ValueTwo());
        }
    }

    public static class ProducerOne {
        @Inject
        @ApplicationScoped
        private InstanceProducer<ValueOne> value;

        public void exec(@Observes(precedence=20) String ba) {
            callOrder.add(this.getClass().getSimpleName());
            this.value.set((Object)new ValueOne());
        }
    }
}

