/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import org.jboss.arquillian.impl.core.ExtensionImpl;
import org.jboss.arquillian.impl.core.spi.EventPoint;
import org.jboss.arquillian.impl.core.spi.InjectionPoint;
import org.jboss.arquillian.impl.core.spi.ObserverMethod;
import org.jboss.arquillian.spi.core.Event;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Assert;
import org.junit.Test;

public class ExtensionParseTestCase {
    @Test
    public void shouldBeAbleToReadAndInvokeObserverMethods() throws Exception {
        ExtensionWithObservers target = new ExtensionWithObservers();
        ExtensionImpl extension = ExtensionImpl.of((Object)target);
        Assert.assertEquals((String)"Verify correct observer methods were found", (long)2L, (long)extension.getObservers().size());
        for (ObserverMethod observer : extension.getObservers()) {
            observer.invoke(null, (Object)new String());
        }
        Assert.assertTrue((boolean)target.methodOneWasCalled);
        Assert.assertTrue((boolean)target.methodTwoWasCalled);
    }

    @Test
    public void shouldBeAbleToReadAndInvokeInjectionPoints() throws Exception {
        ExtensionWithInjection target = new ExtensionWithInjection();
        ExtensionImpl extension = ExtensionImpl.of((Object)target);
        Assert.assertEquals((String)"Verify correct injection fields were found", (long)1L, (long)extension.getInjectionPoints().size());
        DummyInstanceImpl instance = new DummyInstanceImpl();
        for (InjectionPoint point : extension.getInjectionPoints()) {
            point.set((Instance)instance);
        }
        ((ObserverMethod)extension.getObservers().get(0)).invoke(null, new Object());
        Assert.assertTrue((boolean)target.methodOneWasCalled);
        Assert.assertNotNull((Object)instance.get());
    }

    @Test
    public void shouldBeAbleToInjectEventAndFireNewEvent() throws Exception {
        ExtensionWithEvent target = new ExtensionWithEvent();
        ExtensionImpl extension = ExtensionImpl.of((Object)target);
        Assert.assertEquals((String)"Verify correct event fields were found", (long)1L, (long)extension.getEventPoints().size());
        Assert.assertEquals((long)1L, (long)extension.getObservers().size());
        DummyEventImpl event = new DummyEventImpl();
        for (EventPoint point : extension.getEventPoints()) {
            point.set((Event)event);
        }
        ((ObserverMethod)extension.getObservers().get(0)).invoke(null, new Object());
        Assert.assertTrue((boolean)target.methodOneWasCalled);
        Assert.assertEquals((String)"Verify the Extensions Event was firable", (Object)"some string", (Object)event.getString());
    }

    private static class ExtensionWithEvent {
        private boolean methodOneWasCalled = false;
        @Inject
        private Event<String> stringEvent;

        private ExtensionWithEvent() {
        }

        public void methodOne(@Observes Object event) {
            Assert.assertNotNull((Object)event);
            Assert.assertNotNull(this.stringEvent);
            this.stringEvent.fire((Object)"some string");
            this.methodOneWasCalled = true;
        }
    }

    private static class ExtensionWithInjection {
        private boolean methodOneWasCalled = false;
        @Inject
        @ApplicationScoped
        private InstanceProducer<Object> object;

        private ExtensionWithInjection() {
        }

        public void methodOne(@Observes Object event) {
            Assert.assertNotNull(this.object);
            Assert.assertNull((Object)this.object.get());
            this.object.set(new Object());
            this.methodOneWasCalled = true;
        }
    }

    private static class ExtensionWithObservers {
        private boolean methodOneWasCalled = false;
        private boolean methodTwoWasCalled = false;

        private ExtensionWithObservers() {
        }

        public void methodOne(@Observes Object object) {
            this.methodOneWasCalled = true;
        }

        public void methodTwo(@Observes Object object) {
            this.methodTwoWasCalled = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyEventImpl
    implements Event<String> {
        private String object;

        private DummyEventImpl() {
        }

        public void fire(String event) {
            this.object = event;
        }

        public String getString() {
            return this.object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyInstanceImpl
    implements InstanceProducer<Object> {
        private Object object;

        private DummyInstanceImpl() {
        }

        public Object get() {
            return this.object;
        }

        public void set(Object value) {
            this.object = value;
        }
    }
}

