/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.lang.reflect.Field;
import org.jboss.arquillian.impl.core.InjectionPointImpl;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.junit.Assert;
import org.junit.Test;

public class InjectionPointImplTestCase {
    private Instance<InjectionPointImplTestCase> instance;
    @SuiteScoped
    private Instance<InjectionPointImplTestCase> suiteInstance;
    private Instance<GenericWildCard<?>> genericWildCardInstance;

    @Test
    public void shouldBeAbleToDetermineType() throws Exception {
        InjectionPointImpl point = InjectionPointImpl.of((Object)this, (Field)this.getClass().getDeclaredField("instance"));
        Assert.assertEquals(InjectionPointImplTestCase.class, (Object)point.getType());
    }

    @Test
    public void shouldBeAbleToDetermineScope() throws Exception {
        InjectionPointImpl point = InjectionPointImpl.of((Object)this, (Field)this.getClass().getDeclaredField("suiteInstance"));
        Assert.assertEquals(SuiteScoped.class, (Object)point.getScope());
    }

    @Test
    public void shouldBeAbleToFindRawTypeForGenericWildCard() throws Exception {
        InjectionPointImpl point = InjectionPointImpl.of((Object)this, (Field)this.getClass().getDeclaredField("genericWildCardInstance"));
        Assert.assertEquals(GenericWildCard.class, (Object)point.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GenericWildCard<T> {
    }
}

