/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import junit.framework.Assert;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.context.ApplicationContextImpl;
import org.jboss.arquillian.spi.core.Injector;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Test;

public class InjectorTestCase {
    @Test
    public void shouldBeAbleToDoStaticInjection() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extension(TestObserver.class).create();
        ((ApplicationContextImpl)manager.getContext(ApplicationContextImpl.class)).getObjectStore().add(Object.class, new Object());
        manager.fire((Object)"test event");
        Assert.assertTrue((boolean)((TestObserver)manager.getExtension(TestObserver.class)).wasCalled);
    }

    private static class TestStaticInjected {
        @Inject
        private Instance<Object> objectnstance;

        private TestStaticInjected() {
        }

        public void check() {
            Assert.assertNotNull(this.objectnstance);
            Assert.assertNotNull((Object)this.objectnstance.get());
        }
    }

    private static class TestObserver {
        private boolean wasCalled;
        @Inject
        private Instance<Injector> injectorInstance;

        private TestObserver() {
        }

        public void on(@Observes String test) {
            TestStaticInjected target = new TestStaticInjected();
            ((Injector)this.injectorInstance.get()).inject((Object)target);
            target.check();
            this.wasCalled = true;
        }
    }
}

