/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import org.jboss.arquillian.impl.core.InstanceImpl;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.junit.Assert;
import org.junit.Test;

public class InstanceImplTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToLookupInContext() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).create();
        Object testObject = new Object();
        SuiteContext context = (SuiteContext)manager.getContext(SuiteContext.class);
        try {
            context.activate();
            context.getObjectStore().add(Object.class, testObject);
            InstanceImpl instance = InstanceImpl.of(Object.class, SuiteScoped.class, (ManagerImpl)manager);
            Assert.assertEquals((String)"Verify expected object was returned", (Object)testObject, (Object)instance.get());
        }
        finally {
            context.deactivate();
            context.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFireEventOnSet() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).extension(TestObserver.class).create();
        SuiteContext context = (SuiteContext)manager.getContext(SuiteContext.class);
        try {
            context.activate();
            InstanceImpl instance = InstanceImpl.of(Object.class, SuiteScoped.class, (ManagerImpl)manager);
            instance.set(new Object());
            Assert.assertTrue((boolean)((TestObserver)manager.getExtension(TestObserver.class)).wasCalled);
        }
        finally {
            context.deactivate();
            context.destroy();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionIfTryingToSetAUnScopedInstance() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().create();
        InstanceImpl instance = InstanceImpl.of(Object.class, null, (ManagerImpl)manager);
        instance.set(new Object());
        Assert.fail((String)("Should have thrown " + IllegalStateException.class));
    }

    private static class TestObserver {
        private boolean wasCalled = false;

        private TestObserver() {
        }

        public void shouldBeCalled(@Observes Object object) {
            Assert.assertNotNull((Object)object);
            this.wasCalled = true;
        }
    }
}

