/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.context.ContainerContextImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.spi.context.ContainerContext;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.jboss.arquillian.spi.core.Event;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ContainerScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.junit.Assert;
import org.junit.Test;

public class IntegrationTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToInjectAndFireEvents() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).context(ContainerContextImpl.class).extensions(new Class[]{TestObserverOne.class, TestObserverTwo.class, TestObserverTree.class}).create();
        SuiteContext context = (SuiteContext)manager.getContext(SuiteContext.class);
        try {
            context.activate();
            context.getObjectStore().add(Object.class, new Object());
            manager.fire((Object)"some string event");
            Assert.assertTrue((boolean)((TestObserverOne)manager.getExtension(TestObserverOne.class)).wasCalled);
            Assert.assertTrue((boolean)((TestObserverTwo)manager.getExtension(TestObserverTwo.class)).wasCalled);
            Assert.assertTrue((boolean)((TestObserverTree)manager.getExtension(TestObserverTree.class)).wasCalled);
            Assert.assertNotNull((String)"Verify instance was bound to context", (Object)context.getObjectStore().get(Object.class));
            ContainerContext containerContext = (ContainerContext)manager.getContext(ContainerContext.class);
            Assert.assertFalse((boolean)containerContext.isActive());
            containerContext.activate((Object)"");
            try {
                Assert.assertNotNull((String)"Should have set a Double in container scope", (Object)containerContext.getObjectStore().get(Double.class));
            }
            finally {
                containerContext.deactivate();
                containerContext.destroy((Object)"");
            }
        }
        finally {
            context.deactivate();
            context.destroy();
        }
    }

    public static class TestObserverTree {
        private boolean wasCalled = false;
        @Inject
        @ContainerScoped
        private InstanceProducer<Double> doub;

        public void on(@Observes Float integer) {
            this.doub.set((Object)new Double(2.0));
            this.wasCalled = true;
        }
    }

    public static class TestObserverTwo {
        private boolean wasCalled = false;

        public void on(@Observes Integer integer) {
            this.wasCalled = true;
        }
    }

    public static class TestObserverOne {
        private boolean wasCalled = false;
        @Inject
        @SuiteScoped
        private InstanceProducer<Float> object;
        @Inject
        private Event<Integer> event;
        @Inject
        private Instance<ContainerContext> context;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void on(@Observes String name) {
            try {
                ((ContainerContext)this.context.get()).activate((Object)"");
                this.object.set((Object)new Float(2.2));
                this.event.fire((Object)new Integer(100));
            }
            finally {
                ((ContainerContext)this.context.get()).deactivate();
            }
            this.wasCalled = true;
        }
    }
}

