/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.context.ClassContextImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.spi.NonManagedObserver;
import org.jboss.arquillian.impl.core.spi.context.ApplicationContext;
import org.jboss.arquillian.impl.core.spi.context.ClassContext;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.junit.Assert;
import org.junit.Test;

public class ManagerImplTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRegisterContextAndExtensions() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).extension(TestExtension.class).create();
        SuiteContext context = (SuiteContext)manager.getContext(SuiteContext.class);
        try {
            context.activate();
            context.getObjectStore().add(Object.class, new Object());
            manager.fire((Object)"some string");
            Assert.assertTrue((boolean)((TestExtension)manager.getExtension(TestExtension.class)).wasCalled);
        }
        finally {
            context.deactivate();
            context.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBindToTheScopedContext() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).context(ClassContextImpl.class).create();
        SuiteContext suiteContext = (SuiteContext)manager.getContext(SuiteContext.class);
        ClassContext classContext = (ClassContext)manager.getContext(ClassContext.class);
        try {
            suiteContext.activate();
            classContext.activate(this.getClass());
            Object testObject = new Object();
            manager.bind(SuiteScoped.class, Object.class, testObject);
            Assert.assertEquals((String)"Verify value was bound to the correct context", (Object)testObject, (Object)suiteContext.getObjectStore().get(Object.class));
            Assert.assertNull((String)"Verify value was not bound to any other context", (Object)classContext.getObjectStore().get(Object.class));
        }
        finally {
            classContext.deactivate();
            classContext.destroy(this.getClass());
            suiteContext.deactivate();
            suiteContext.destroy();
        }
    }

    @Test
    public void shouldResolveToNullIfNoActiveContexts() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().create();
        Assert.assertNull((Object)manager.resolve(Object.class));
    }

    @Test
    public void shouldResolveToNullContextIfNotFound() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().create();
        Assert.assertNull((Object)manager.getContext(SuiteContextImpl.class));
    }

    @Test
    public void shouldResolveToNullExtensionIfNotFound() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().create();
        Assert.assertNull((Object)manager.getExtension(SuiteContextImpl.class));
    }

    @Test
    public void shouldCallNonManagedObserver() throws Exception {
        String testEvent = "test";
        TestNonManagedObserver observer = new TestNonManagedObserver();
        ManagerImpl manager = ManagerBuilder.from().create();
        manager.fire((Object)"test", (NonManagedObserver)observer);
        Assert.assertNotNull((String)"NonManagedObserver should have been called", (Object)TestNonManagedObserver.firedEvent);
        Assert.assertEquals((String)"NonManagedObserver should have received fired event", (Object)TestNonManagedObserver.firedEvent, (Object)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnBindWithNoFoundScopedContext() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().create();
        manager.bind(SuiteScoped.class, Object.class, new Object());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnBindWithNonActiveScopedContext() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().context(SuiteContextImpl.class).create();
        manager.bind(SuiteScoped.class, Object.class, new Object());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestNonManagedObserver
    implements NonManagedObserver<String> {
        private static String firedEvent = null;
        @Inject
        private Instance<ApplicationContext> applicationContext;

        private TestNonManagedObserver() {
        }

        public void fired(String event) {
            firedEvent = event;
            if (this.applicationContext == null) {
                throw new IllegalStateException("ApplicationContext should have been injected, but was null");
            }
        }
    }

    private static class TestExtension {
        private boolean wasCalled = false;
        @Inject
        private Instance<Object> value;

        private TestExtension() {
        }

        public void on(@Observes String object) {
            Assert.assertNotNull((String)"Verify event is not null", (Object)object);
            Assert.assertNotNull((String)"Verify InjectionPoint is not null", this.value);
            Assert.assertNotNull((String)"Verify InjectionPoint value is not null", (Object)this.value.get());
            this.wasCalled = true;
        }
    }
}

