/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.spi.EventContext;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Assert;
import org.junit.Test;

public class ObserverInterceptorTestCase
extends AbstractManagerTestBase {
    public static List<String> callStack = new ArrayList<String>();

    public ObserverInterceptorTestCase() {
        ManagerImpl.DEBUG = false;
    }

    protected void addExtensions(ManagerBuilder builder) {
        builder.extensions(new Class[]{InterceptorObserver.class, InterceptorObserver2.class, Observer.class});
    }

    @Test
    public void shouldInterceptEvent() throws Exception {
        this.fire("test");
        Assert.assertEquals((Object)InterceptorObserver2.class.getSimpleName(), (Object)callStack.get(0));
        Assert.assertEquals((Object)InterceptorObserver.class.getSimpleName(), (Object)callStack.get(1));
        Assert.assertEquals((Object)Observer.class.getSimpleName(), (Object)callStack.get(2));
        Assert.assertEquals((Object)InterceptorObserver.class.getSimpleName(), (Object)callStack.get(3));
        Assert.assertEquals((Object)InterceptorObserver2.class.getSimpleName(), (Object)callStack.get(4));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InterceptorObserver2 {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void around(@Observes(precedence=1) EventContext<String> event) {
            callStack.add(InterceptorObserver2.class.getSimpleName());
            try {
                event.proceed();
            }
            finally {
                callStack.add(InterceptorObserver2.class.getSimpleName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InterceptorObserver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void around(@Observes EventContext<String> event) {
            callStack.add(InterceptorObserver.class.getSimpleName());
            try {
                event.proceed();
            }
            finally {
                callStack.add(InterceptorObserver.class.getSimpleName());
            }
        }
    }

    public static class Observer {
        public void around(@Observes String event) {
            callStack.add(Observer.class.getSimpleName());
        }
    }
}

