/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import junit.framework.Assert;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.ManagerImpl;
import org.jboss.arquillian.impl.core.spi.context.ApplicationContext;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.junit.Test;

public class ObserverMethodAvailabilityFilterTestCase {
    @Test
    public void shouldCallFilteredMethodsIfInContext() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extension(ObserverMultiArgument.class).create();
        ((ApplicationContext)manager.getContext(ApplicationContext.class)).getObjectStore().add(Integer.class, (Object)10);
        manager.fire((Object)new String("_TEST_"));
        ObserverMultiArgument extension = (ObserverMultiArgument)manager.getExtension(ObserverMultiArgument.class);
        Assert.assertTrue((String)"Non filtered method should have been called", (boolean)extension.wasCalled);
        Assert.assertTrue((String)"Filtered method should not have been called, filter not in context", (boolean)extension.filteredWasCalled);
    }

    @Test
    public void shouldNotCallFilteredMethodsIfNotInContext() throws Exception {
        ManagerImpl manager = ManagerBuilder.from().extension(ObserverMultiArgument.class).create();
        manager.fire((Object)new String("_TEST_"));
        ObserverMultiArgument extension = (ObserverMultiArgument)manager.getExtension(ObserverMultiArgument.class);
        Assert.assertTrue((String)"Non filtered method should have been called", (boolean)extension.wasCalled);
        Assert.assertFalse((String)"Filtered method should not have been called, filter not in context", (boolean)extension.filteredWasCalled);
    }

    public static class ObserverMultiArgument {
        private boolean wasCalled = false;
        private boolean filteredWasCalled = false;

        public void single(@Observes String test) {
            this.wasCalled = true;
        }

        public void filtered(@Observes String test, Integer filter) {
            Assert.assertNotNull((Object)filter);
            this.filteredWasCalled = true;
        }
    }
}

